/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class BodyRenderer
extends CoreRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        writer.startElement("body", component);
        if (this.shouldWriteId(component)) {
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        if ((styleClass = (String)component.getAttributes().get("styleClass")) != null && styleClass.length() != 0) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderPassThruAttributes(context, component, HTML.BODY_ATTRS);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        RequestContext requestContext = RequestContext.getCurrentInstance();
        this.encodeResources(context);
        if (!requestContext.isAjaxRequest()) {
            this.encodeOnloadScripts(writer, requestContext);
        }
        writer.endElement("body");
    }

    protected void encodeOnloadScripts(ResponseWriter writer, RequestContext context) throws IOException {
        List<String> scripts = context.getScriptsToExecute();
        if (!scripts.isEmpty()) {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("$(function(){");
            for (int i = 0; i < scripts.size(); ++i) {
                writer.write(scripts.get(i));
                writer.write(59);
            }
            writer.write("});");
            writer.endElement("script");
        }
    }

    protected void encodeResources(FacesContext context) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(context, "body").listIterator();
        while (iter.hasNext()) {
            UIComponent resource = (UIComponent)iter.next();
            resource.encodeAll(context);
        }
    }
}

