/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.panelgrid.PanelGrid;
import org.primefaces.mobile.util.MobileUtils;

public class PanelGridRenderer
extends org.primefaces.component.panelgrid.PanelGridRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PanelGrid grid = (PanelGrid)component;
        String clientId = grid.getClientId(context);
        int columns = grid.getColumns();
        if (columns == 0) {
            columns = 1;
        }
        String gridClass = MobileUtils.GRID_MAP.get(columns);
        String style = grid.getStyle();
        String styleClass = grid.getStyleClass();
        styleClass = styleClass == null ? gridClass : gridClass + " " + styleClass;
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        int i = 0;
        for (UIComponent child : grid.getChildren()) {
            if (!child.isRendered()) continue;
            int blockKey = i % columns;
            String blockClass = MobileUtils.BLOCK_MAP.get(blockKey);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)blockClass, null);
            child.encodeAll(context);
            writer.endElement("div");
            ++i;
        }
        writer.endElement("div");
    }
}

