/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.feature.CellEditFeature;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.DraggableColumnsFeature;
import org.primefaces.component.datatable.feature.DraggableRowsFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.component.datatable.feature.PageFeature;
import org.primefaces.component.datatable.feature.ResizableColumnsFeature;
import org.primefaces.component.datatable.feature.RowEditFeature;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.ScrollFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.context.RequestContext;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.ReorderEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.event.ToggleSelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SelectableDataModelWrapper;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.Visibility;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class DataTable
extends UIData
implements Widget,
RTLAware,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DataTableRenderer";
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    private static final String SB_GET_SELECTED_ROW_KEYS_AS_STRING = DataTable.class.getName() + "#getSelectedRowKeysAsString";
    public static final String CONTAINER_CLASS = "ui-datatable ui-widget";
    public static final String TABLE_WRAPPER_CLASS = "ui-datatable-tablewrapper";
    public static final String RTL_CLASS = "ui-datatable-rtl";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String DYNAMIC_COLUMN_HEADER_CLASS = "ui-dynamic-column";
    public static final String COLUMN_HEADER_CONTAINER_CLASS = "ui-header-column";
    public static final String COLUMN_FOOTER_CLASS = "ui-state-default";
    public static final String COLUMN_FOOTER_CONTAINER_CLASS = "ui-footer-column";
    public static final String DATA_CLASS = "ui-datatable-data ui-widget-content";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTABLE_ROW_CLASS = "ui-datatable-selectable";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-datatable-empty-message";
    public static final String HEADER_CLASS = "ui-datatable-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datatable-footer ui-widget-header ui-corner-bottom";
    public static final String SORTABLE_COLUMN_CLASS = "ui-sortable-column";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String STATIC_COLUMN_CLASS = "ui-static-column";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_TITLE_CLASS = "ui-column-title";
    public static final String COLUMN_FILTER_CLASS = "ui-column-filter ui-widget ui-state-default ui-corner-left";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String COLUMN_CUSTOM_FILTER_CLASS = "ui-column-customfilter";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String EXPANDED_ROW_CLASS = "ui-expanded-row";
    public static final String EXPANDED_ROW_CONTENT_CLASS = "ui-expanded-row-content";
    public static final String ROW_TOGGLER_CLASS = "ui-row-toggler";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String CELL_EDITOR_CLASS = "ui-cell-editor";
    public static final String CELL_EDITOR_INPUT_CLASS = "ui-cell-editor-input";
    public static final String CELL_EDITOR_OUTPUT_CLASS = "ui-cell-editor-output";
    public static final String ROW_EDITOR_COLUMN_CLASS = "ui-row-editor-column";
    public static final String ROW_EDITOR_CLASS = "ui-row-editor ui-helper-clearfix";
    public static final String SELECTION_COLUMN_CLASS = "ui-selection-column";
    public static final String EVEN_ROW_CLASS = "ui-datatable-even";
    public static final String ODD_ROW_CLASS = "ui-datatable-odd";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-datatable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-datatable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-datatable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-datatable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-datatable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-datatable-scrollable-footer-box";
    public static final String COLUMN_RESIZER_CLASS = "ui-column-resizer";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-datatable-resizable";
    public static final String SUBTABLE_HEADER = "ui-datatable-subtable-header";
    public static final String SUBTABLE_FOOTER = "ui-datatable-subtable-footer";
    public static final String SUMMARY_ROW_CLASS = "ui-datatable-summaryrow ui-widget-header";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    public static final String STICKY_HEADER_CLASS = "ui-datatable-sticky";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("page", "sort", "filter", "rowSelect", "rowUnselect", "rowEdit", "rowEditInit", "rowEditCancel", "colResize", "toggleSelect", "colReorder", "contextMenu", "rowSelectRadio", "rowSelectCheckbox", "rowUnselectCheckbox", "rowDblselect", "rowToggle", "cellEdit", "rowReorder"));
    static Map<DataTableFeatureKey, DataTableFeature> FEATURES = new HashMap<DataTableFeatureKey, DataTableFeature>();
    private List filterMetadata;
    private boolean reset = false;
    private SelectableDataModelWrapper selectableDataModelWrapper = null;
    private List<Object> selectedRowKeys = new ArrayList<Object>();
    private int columnsCount = -1;
    private List<UIColumn> columns;
    private UIColumn sortColumn;
    private List<SortMeta> multiSortMeta;
    private Columns dynamicColumns;
    private ValueExpression sortByVE;
    private List<UIComponent> iterableChildren;

    public DataTable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public boolean isScrollable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollable), (Object)false);
    }

    public void setScrollable(boolean _scrollable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollable), (Object)_scrollable);
    }

    public String getScrollHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollHeight), null);
    }

    public void setScrollHeight(String _scrollHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollHeight), (Object)_scrollHeight);
    }

    public String getScrollWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollWidth), null);
    }

    public void setScrollWidth(String _scrollWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollWidth), (Object)_scrollWidth);
    }

    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), null);
    }

    public void setSelectionMode(String _selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)_selectionMode);
    }

    public Object getSelection() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection), null);
    }

    public void setSelection(Object _selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), _selection);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public boolean isLiveScroll() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveScroll), (Object)false);
    }

    public void setLiveScroll(boolean _liveScroll) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveScroll), (Object)_liveScroll);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public void setRowStyleClass(String _rowStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)_rowStyleClass);
    }

    public String getOnExpandStart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onExpandStart), null);
    }

    public void setOnExpandStart(String _onExpandStart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onExpandStart), (Object)_onExpandStart);
    }

    public boolean isResizableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableColumns), (Object)false);
    }

    public void setResizableColumns(boolean _resizableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableColumns), (Object)_resizableColumns);
    }

    public Object getSortBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortBy), null);
    }

    public void setSortBy(Object _sortBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortBy), _sortBy);
    }

    public String getSortOrder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)"ascending");
    }

    public void setSortOrder(String _sortOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)_sortOrder);
    }

    public MethodExpression getSortFunction() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortFunction), null);
    }

    public void setSortFunction(MethodExpression _sortFunction) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortFunction), (Object)_sortFunction);
    }

    public int getScrollRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollRows), (Object)0);
    }

    public void setScrollRows(int _scrollRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollRows), (Object)_scrollRows);
    }

    public Object getRowKey() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowKey), null);
    }

    public void setRowKey(Object _rowKey) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowKey), _rowKey);
    }

    public String getFilterEvent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterEvent), null);
    }

    public void setFilterEvent(String _filterEvent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterEvent), (Object)_filterEvent);
    }

    public int getFilterDelay() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterDelay), (Object)Integer.MAX_VALUE);
    }

    public void setFilterDelay(int _filterDelay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterDelay), (Object)_filterDelay);
    }

    public String getTableStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyle), null);
    }

    public void setTableStyle(String _tableStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyle), (Object)_tableStyle);
    }

    public String getTableStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyleClass), null);
    }

    public void setTableStyleClass(String _tableStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyleClass), (Object)_tableStyleClass);
    }

    public boolean isDraggableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggableColumns), (Object)false);
    }

    public void setDraggableColumns(boolean _draggableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggableColumns), (Object)_draggableColumns);
    }

    public boolean isEditable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editable), (Object)false);
    }

    public void setEditable(boolean _editable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editable), (Object)_editable);
    }

    public List getFilteredValue() {
        return (List)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filteredValue), null);
    }

    public void setFilteredValue(List _filteredValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filteredValue), (Object)_filteredValue);
    }

    public String getSortMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortMode), (Object)"single");
    }

    public void setSortMode(String _sortMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortMode), (Object)_sortMode);
    }

    public String getEditMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editMode), (Object)"row");
    }

    public void setEditMode(String _editMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editMode), (Object)_editMode);
    }

    public boolean isEditingRow() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editingRow), (Object)false);
    }

    public void setEditingRow(boolean _editingRow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editingRow), (Object)_editingRow);
    }

    public String getCellSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cellSeparator), null);
    }

    public void setCellSeparator(String _cellSeparator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cellSeparator), (Object)_cellSeparator);
    }

    public String getSummary() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.summary), null);
    }

    public void setSummary(String _summary) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.summary), (Object)_summary);
    }

    public int getFrozenRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.frozenRows), (Object)0);
    }

    public void setFrozenRows(int _frozenRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.frozenRows), (Object)_frozenRows);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public void setDir(String _dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)_dir);
    }

    public boolean isLiveResize() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveResize), (Object)false);
    }

    public void setLiveResize(boolean _liveResize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveResize), (Object)_liveResize);
    }

    public boolean isStickyHeader() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stickyHeader), (Object)false);
    }

    public void setStickyHeader(boolean _stickyHeader) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stickyHeader), (Object)_stickyHeader);
    }

    public boolean isExpandedRow() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expandedRow), (Object)false);
    }

    public void setExpandedRow(boolean _expandedRow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expandedRow), (Object)_expandedRow);
    }

    public boolean isDisabledSelection() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabledSelection), (Object)false);
    }

    public void setDisabledSelection(boolean _disabledSelection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabledSelection), (Object)_disabledSelection);
    }

    public String getRowSelectMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowSelectMode), (Object)"new");
    }

    public void setRowSelectMode(String _rowSelectMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowSelectMode), (Object)_rowSelectMode);
    }

    public String getRowExpandMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowExpandMode), (Object)"multiple");
    }

    public void setRowExpandMode(String _rowExpandMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowExpandMode), (Object)_rowExpandMode);
    }

    public Object getDataLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dataLocale), null);
    }

    public void setDataLocale(Object _dataLocale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dataLocale), _dataLocale);
    }

    public boolean isNativeElements() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nativeElements), (Object)false);
    }

    public void setNativeElements(boolean _nativeElements) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nativeElements), (Object)_nativeElements);
    }

    public int getFrozenColumns() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.frozenColumns), (Object)Integer.MIN_VALUE);
    }

    public void setFrozenColumns(int _frozenColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.frozenColumns), (Object)_frozenColumns);
    }

    public boolean isDraggableRows() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggableRows), (Object)false);
    }

    public void setDraggableRows(boolean _draggableRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggableRows), (Object)_draggableRows);
    }

    public boolean isCaseSensitiveSort() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)false);
    }

    public void setCaseSensitiveSort(boolean _caseSensitiveSort) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)_caseSensitiveSort);
    }

    public boolean isSkipChildren() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.skipChildren), (Object)false);
    }

    public void setSkipChildren(boolean _skipChildren) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.skipChildren), (Object)_skipChildren);
    }

    public DataTableFeature getFeature(DataTableFeatureKey key) {
        return FEATURES.get((Object)key);
    }

    public boolean shouldEncodeFeature(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_encodeFeature");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditAction");
    }

    public boolean isRowEditCancelRequest(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(this.getClientId(context) + "_rowEditAction");
        return value != null && value.equals("cancel");
    }

    public boolean isRowSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    public boolean isColumnSelectionEnabled() {
        return this.getColumnSelectionMode() != null;
    }

    public String getColumnSelectionMode() {
        for (UIComponent child : this.getChildren()) {
            String selectionMode;
            if (!child.isRendered() || !(child instanceof Column) || (selectionMode = ((Column)child).getSelectionMode()) == null) continue;
            return selectionMode;
        }
        return null;
    }

    public boolean isSelectionEnabled() {
        return this.isRowSelectionEnabled() || this.isColumnSelectionEnabled();
    }

    public boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        if (selectionMode != null) {
            return selectionMode.equalsIgnoreCase("single");
        }
        if (columnSelectionMode != null) {
            return columnSelectionMode.equalsIgnoreCase("single");
        }
        return false;
    }

    @Override
    public void processValidators(FacesContext context) {
        super.processValidators(context);
        if (this.isFilterRequest(context)) {
            FEATURES.get((Object)DataTableFeatureKey.FILTER).decode(context, this);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        ValueExpression selectionVE = this.getValueExpression("selection");
        if (selectionVE != null) {
            selectionVE.setValue(context.getELContext(), this.getLocalSelection());
            this.setSelection(null);
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("rowSelect") || eventName.equals("rowSelectRadio") || eventName.equals("contextMenu") || eventName.equals("rowSelectCheckbox") || eventName.equals("rowDblselect")) {
                String rowKey = (String)params.get(clientId + "_instantSelectedRowKey");
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("rowUnselect") || eventName.equals("rowUnselectCheckbox")) {
                String rowKey = (String)params.get(clientId + "_instantUnselectedRowKey");
                wrapperEvent = new UnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("page")) {
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
            } else if (eventName.equals("sort")) {
                UIColumn sortColumn;
                SortOrder order;
                if (this.isMultiSort()) {
                    String[] sortDirs = ((String)params.get(clientId + "_sortDir")).split(",");
                    String[] sortKeys = ((String)params.get(clientId + "_sortKey")).split(",");
                    order = SortOrder.valueOf(((SortFeature)FEATURES.get((Object)DataTableFeatureKey.SORT)).convertSortOrderParam(sortDirs[sortDirs.length - 1]));
                    sortColumn = this.findColumn(sortKeys[sortKeys.length - 1]);
                } else {
                    order = SortOrder.valueOf(((SortFeature)FEATURES.get((Object)DataTableFeatureKey.SORT)).convertSortOrderParam((String)params.get(clientId + "_sortDir")));
                    sortColumn = this.findColumn((String)params.get(clientId + "_sortKey"));
                }
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), sortColumn, order);
            } else if (eventName.equals("filter")) {
                wrapperEvent = new FilterEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getFilteredValue(), this.getFilters());
            } else if (eventName.equals("rowEdit") || eventName.equals("rowEditCancel") || eventName.equals("rowEditInit")) {
                int rowIndex = Integer.parseInt((String)params.get(clientId + "_rowEditIndex"));
                this.setRowIndex(rowIndex);
                wrapperEvent = new RowEditEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Double.valueOf((String)params.get(clientId + "_width")).intValue();
                int height = Double.valueOf((String)params.get(clientId + "_height")).intValue();
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if (eventName.equals("toggleSelect")) {
                boolean checked = Boolean.valueOf((String)params.get(clientId + "_checked"));
                wrapperEvent = new ToggleSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), checked);
            } else if (eventName.equals("colReorder")) {
                wrapperEvent = behaviorEvent;
            } else if (eventName.equals("rowToggle")) {
                boolean expansion = params.containsKey(clientId + "_rowExpansion");
                Visibility visibility = expansion ? Visibility.VISIBLE : Visibility.HIDDEN;
                String rowIndex = expansion ? (String)params.get(clientId + "_expandedRowIndex") : (String)params.get(clientId + "_collapsedRowIndex");
                this.setRowIndex(Integer.parseInt(rowIndex));
                wrapperEvent = new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility, this.getRowData());
            } else if (eventName.equals("cellEdit")) {
                String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                int rowIndex = Integer.parseInt(cellInfo[0]);
                int cellIndex = Integer.parseInt(cellInfo[1]);
                int i = -1;
                UIColumn column = null;
                for (UIColumn col : this.getColumns()) {
                    if (!col.isRendered() || ++i != cellIndex) continue;
                    column = col;
                    break;
                }
                wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), rowIndex, column);
            } else if (eventName.equals("rowReorder")) {
                int fromIndex = Integer.parseInt((String)params.get(clientId + "_fromIndex"));
                int toIndex = Integer.parseInt((String)params.get(clientId + "_toIndex"));
                wrapperEvent = new ReorderEvent((UIComponent)this, behaviorEvent.getBehavior(), fromIndex, toIndex);
            }
            wrapperEvent.setPhaseId(event.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public UIColumn findColumn(String clientId) {
        for (UIColumn column : this.getColumns()) {
            if (!column.getColumnKey().equals(clientId)) continue;
            return column;
        }
        FacesContext context = this.getFacesContext();
        ColumnGroup headerGroup = this.getColumnGroup("header");
        for (UIComponent row : headerGroup.getChildren()) {
            for (UIComponent col : row.getChildren()) {
                if (!col.getClientId(context).equals(clientId)) continue;
                return (UIColumn)col;
            }
        }
        throw new FacesException("Cannot find column with key: " + clientId);
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public boolean hasFooterColumn() {
        for (UIComponent child : this.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = null;
            data = this.isMultiSort() ? lazyModel.load(this.getFirst(), this.getRows(), this.getMultiSortMeta(), this.getFilters()) : lazyModel.load(this.getFirst(), this.getRows(), this.resolveSortField(), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (this.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void loadLazyScrollData(int offset, int rows) {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = null;
            data = this.isMultiSort() ? lazyModel.load(offset, rows, this.getMultiSortMeta(), this.getFilters()) : lazyModel.load(offset, rows, this.resolveSortField(), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(rows);
            lazyModel.setWrappedData(data);
            if (this.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    protected String resolveSortField() {
        UIColumn column = this.getSortColumn();
        String sortField = null;
        ValueExpression tableSortByVE = this.getValueExpression("sortBy");
        Object tableSortByProperty = this.getSortBy();
        if (column == null) {
            sortField = tableSortByVE == null ? (String)tableSortByProperty : this.resolveStaticField(tableSortByVE);
        } else {
            ValueExpression columnSortByVE = column.getValueExpression("sortBy");
            if (column.isDynamic()) {
                ((DynamicColumn)this.sortColumn).applyStatelessModel();
                Object sortByProperty = this.sortColumn.getSortBy();
                String field = column.getField();
                sortField = field == null ? (sortByProperty == null ? this.resolveDynamicField(columnSortByVE) : sortByProperty.toString()) : field;
            } else {
                String field = column.getField();
                sortField = field == null ? (columnSortByVE == null ? (String)column.getSortBy() : this.resolveStaticField(columnSortByVE)) : field;
            }
        }
        return sortField;
    }

    public SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        return SortOrder.valueOf(sortOrder.toUpperCase(Locale.ENGLISH));
    }

    public String resolveStaticField(ValueExpression expression) {
        if (expression != null) {
            String expressionString = expression.getExpressionString();
            expressionString = expressionString.substring(2, expressionString.length() - 1);
            return expressionString.substring(expressionString.indexOf(".") + 1);
        }
        return null;
    }

    public String resolveDynamicField(ValueExpression expression) {
        if (expression != null) {
            String expressionString = expression.getExpressionString();
            expressionString = expressionString.substring(expressionString.indexOf("[") + 1, expressionString.indexOf("]"));
            expressionString = "#{" + expressionString + "}";
            FacesContext context = this.getFacesContext();
            ELContext eLContext = context.getELContext();
            ValueExpression dynaVE = context.getApplication().getExpressionFactory().createValueExpression(eLContext, expressionString, String.class);
            return (String)dynaVE.getValue(eLContext);
        }
        return null;
    }

    public void clearLazyCache() {
        LazyDataModel model = (LazyDataModel)this.getDataModel();
        model.setWrappedData(null);
    }

    public Map<String, Object> getFilters() {
        return (Map)this.getStateHelper().eval((Serializable)((Object)"filters"), new HashMap());
    }

    public void setFilters(Map<String, Object> filters) {
        this.getStateHelper().put((Serializable)((Object)"filters"), filters);
    }

    public List getFilterMetadata() {
        return this.filterMetadata;
    }

    public void setFilterMetadata(List filterMetadata) {
        this.filterMetadata = filterMetadata;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void resetValue() {
        this.setValue(null);
        this.setFilteredValue(null);
        this.setFilters(null);
    }

    public void reset() {
        this.resetValue();
        this.setFirst(0);
        this.reset = true;
    }

    public boolean isFilteringEnabled() {
        Object value = this.getStateHelper().get((Serializable)((Object)"filtering"));
        return value != null;
    }

    public void enableFiltering() {
        this.getStateHelper().put((Serializable)((Object)"filtering"), (Object)true);
    }

    public RowExpansion getRowExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof RowExpansion)) continue;
            return (RowExpansion)kid;
        }
        return null;
    }

    public Object getValue() {
        Object value = super.getValue();
        List filteredValue = this.getFilteredValue();
        if (filteredValue != null) {
            if (value instanceof SelectableDataModel) {
                return this.selectableDataModelWrapper == null ? (this.selectableDataModelWrapper = new SelectableDataModelWrapper((SelectableDataModel)value, filteredValue)) : this.selectableDataModelWrapper;
            }
            return filteredValue;
        }
        return value;
    }

    public void setSelectableDataModelWrapper(SelectableDataModelWrapper wrapper) {
        this.selectableDataModelWrapper = wrapper;
    }

    public Object getLocalSelection() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.selection));
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isRequestSource(FacesContext context) {
        String partialSource = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        return partialSource != null && this.getClientId(context).equals(partialSource);
    }

    public boolean isBodyUpdate(FacesContext context) {
        String clientId = this.getClientId(context);
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_updateBody");
    }

    public SubTable getSubTable() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof SubTable)) continue;
            return (SubTable)kid;
        }
        return null;
    }

    public Object getRowKeyFromModel(Object object) {
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled.");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowKey(object);
    }

    public Object getRowData(String rowKey) {
        boolean hasRowKeyVe;
        boolean bl = hasRowKeyVe = this.getValueExpression("rowKey") != null;
        if (hasRowKeyVe) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            String var = this.getVar();
            Collection data = (Collection)this.getDataModel().getWrappedData();
            for (Object object : data) {
                requestMap.put(var, object);
                if (!String.valueOf(this.getRowKey()).equals(rowKey)) continue;
                return object;
            }
            return null;
        }
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled or you need to define rowKey attribute");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowData(rowKey);
    }

    public void findSelectedRowKeys() {
        block6: {
            Object selection = this.getSelection();
            this.selectedRowKeys = new ArrayList<Object>();
            boolean hasRowKeyVe = this.getValueExpression("rowKey") != null;
            String var = this.getVar();
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (!this.isSelectionEnabled() || selection == null) break block6;
            if (this.isSingleSelectionMode()) {
                this.addToSelectedRowKeys(selection, requestMap, var, hasRowKeyVe);
            } else if (selection.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(selection); ++i) {
                    this.addToSelectedRowKeys(Array.get(selection, i), requestMap, var, hasRowKeyVe);
                }
            } else {
                List list = (List)selection;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.addToSelectedRowKeys(it.next(), requestMap, var, hasRowKeyVe);
                }
            }
        }
    }

    protected void addToSelectedRowKeys(Object object, Map<String, Object> map, String var, boolean hasRowKey) {
        if (hasRowKey) {
            map.put(var, object);
            this.selectedRowKeys.add(this.getRowKey());
        } else {
            this.selectedRowKeys.add(this.getRowKeyFromModel(object));
        }
    }

    protected List<Object> getSelectedRowKeys() {
        return this.selectedRowKeys;
    }

    protected String getSelectedRowKeysAsString() {
        StringBuilder builder = SharedStringBuilder.get(SB_GET_SELECTED_ROW_KEYS_AS_STRING);
        Iterator<Object> iter = this.getSelectedRowKeys().iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public SummaryRow getSummaryRow() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof SummaryRow)) continue;
            return (SummaryRow)kid;
        }
        return null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Columns) {
                    int dynamicColumnsCount = ((Columns)kid).getRowCount();
                    if (dynamicColumnsCount <= 0) continue;
                    this.columnsCount += dynamicColumnsCount;
                    continue;
                }
                if (kid instanceof Column) {
                    ++this.columnsCount;
                    continue;
                }
                if (!(kid instanceof SubTable)) continue;
                SubTable subTable = (SubTable)kid;
                for (UIComponent subTableKid : subTable.getChildren()) {
                    if (!subTableKid.isRendered() || !(subTableKid instanceof Column)) continue;
                    ++this.columnsCount;
                }
            }
        }
        return this.columnsCount;
    }

    public List<UIColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<UIColumn>();
            FacesContext context = this.getFacesContext();
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Column) {
                    this.columns.add((UIColumn)child);
                    continue;
                }
                if (!(child instanceof Columns)) continue;
                Columns uiColumns = (Columns)child;
                String uiColumnsClientId = uiColumns.getClientId(context);
                for (int i = 0; i < uiColumns.getRowCount(); ++i) {
                    DynamicColumn dynaColumn = new DynamicColumn(i, uiColumns);
                    dynaColumn.setColumnKey(uiColumnsClientId + separator + i);
                    this.columns.add(dynaColumn);
                }
            }
        }
        return this.columns;
    }

    public void setColumns(List<UIColumn> columns) {
        this.columns = columns;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    @Override
    protected boolean shouldSkipChildren(FacesContext context) {
        return this.isSkipChildren() || context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_skipChildren");
    }

    public void setSortColumn(UIColumn column) {
        this.sortColumn = column;
    }

    public UIColumn getSortColumn() {
        return this.sortColumn;
    }

    public boolean isMultiSort() {
        String sortMode = this.getSortMode();
        return sortMode != null && sortMode.equals("multiple");
    }

    public List<SortMeta> getMultiSortMeta() {
        ValueExpression ve;
        if (this.multiSortMeta == null && (ve = this.getValueExpression("sortBy")) != null) {
            this.multiSortMeta = (List)ve.getValue(this.getFacesContext().getELContext());
        }
        return this.multiSortMeta;
    }

    public void setMultiSortMeta(List<SortMeta> value) {
        this.multiSortMeta = value;
    }

    @Override
    public boolean isRTL() {
        return this.getDir().equalsIgnoreCase("rtl");
    }

    public String resolveSelectionMode() {
        String tableSelectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        String selectionMode = null;
        if (tableSelectionMode != null) {
            selectionMode = tableSelectionMode;
        } else if (columnSelectionMode != null) {
            selectionMode = columnSelectionMode.equals("single") ? "radio" : "checkbox";
        }
        return selectionMode;
    }

    @Override
    protected boolean requiresColumns() {
        return true;
    }

    public void setDynamicColumns(Columns value) {
        this.dynamicColumns = value;
    }

    public Columns getDynamicColumns() {
        return this.dynamicColumns;
    }

    @Override
    protected void processColumnFacets(FacesContext context, PhaseId phaseId) {
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof UIColumn) {
                    if (child instanceof Column) {
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                        continue;
                    }
                    if (!(child instanceof Columns)) continue;
                    Columns uicolumns = (Columns)child;
                    int f = uicolumns.getFirst();
                    int r = uicolumns.getRows();
                    int l = r == 0 ? uicolumns.getRowCount() : f + r;
                    for (int i = f; i < l; ++i) {
                        uicolumns.setRowIndex(i);
                        if (!uicolumns.isRowAvailable()) break;
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                    }
                    uicolumns.setRowIndex(-1);
                    continue;
                }
                if (!(child instanceof ColumnGroup) || child.getChildCount() <= 0) continue;
                for (UIComponent row : child.getChildren()) {
                    if (row.getChildCount() <= 0) continue;
                    for (UIComponent col : row.getChildren()) {
                        if (!(col instanceof Column) || col.getFacetCount() <= 0) continue;
                        for (UIComponent facet : col.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                    }
                }
            }
        }
    }

    public void setSortByVE(ValueExpression ve) {
        this.sortByVE = ve;
    }

    public ValueExpression getSortByVE() {
        return this.sortByVE;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        Object userLocale = this.getDataLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                return ComponentUtils.toLocale((String)userLocale);
            }
            if (userLocale instanceof Locale) {
                return (Locale)userLocale;
            }
            throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for datatable:" + this.getClientId(context));
        }
        return context.getViewRoot().getLocale();
    }

    private boolean isFilterRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_filtering");
    }

    @Override
    protected List<UIComponent> getIterableChildren() {
        if (this.iterableChildren == null) {
            this.iterableChildren = new ArrayList<UIComponent>();
            for (UIComponent child : this.getChildren()) {
                if (child instanceof ColumnGroup) continue;
                this.iterableChildren.add(child);
            }
        }
        return this.iterableChildren;
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    static {
        FEATURES.put(DataTableFeatureKey.DRAGGABLE_COLUMNS, new DraggableColumnsFeature());
        FEATURES.put(DataTableFeatureKey.FILTER, new FilterFeature());
        FEATURES.put(DataTableFeatureKey.PAGE, new PageFeature());
        FEATURES.put(DataTableFeatureKey.SORT, new SortFeature());
        FEATURES.put(DataTableFeatureKey.RESIZABLE_COLUMNS, new ResizableColumnsFeature());
        FEATURES.put(DataTableFeatureKey.SELECT, new SelectionFeature());
        FEATURES.put(DataTableFeatureKey.ROW_EDIT, new RowEditFeature());
        FEATURES.put(DataTableFeatureKey.CELL_EDIT, new CellEditFeature());
        FEATURES.put(DataTableFeatureKey.ROW_EXPAND, new RowExpandFeature());
        FEATURES.put(DataTableFeatureKey.SCROLL, new ScrollFeature());
        FEATURES.put(DataTableFeatureKey.DRAGGABLE_ROWS, new DraggableRowsFeature());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        scrollable,
        scrollHeight,
        scrollWidth,
        selectionMode,
        selection,
        emptyMessage,
        style,
        styleClass,
        liveScroll,
        rowStyleClass,
        onExpandStart,
        resizableColumns,
        sortBy,
        sortOrder,
        sortFunction,
        scrollRows,
        rowKey,
        filterEvent,
        filterDelay,
        tableStyle,
        tableStyleClass,
        draggableColumns,
        editable,
        filteredValue,
        sortMode,
        editMode,
        editingRow,
        cellSeparator,
        summary,
        frozenRows,
        dir,
        liveResize,
        stickyHeader,
        expandedRow,
        disabledSelection,
        rowSelectMode,
        rowExpandMode,
        dataLocale,
        nativeElements,
        frozenColumns,
        draggableRows,
        caseSensitiveSort,
        skipChildren;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

