/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.j2semodule.J2SEModularProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class J2SEModularProjectGenerator {
    private static final String DEFAULT_PLATFORM_ID = "default_platform";
    private static final String PROP_PLATFORM_ANT_NAME = "platform.ant.name";
    private static final String METRICS_LOGGER = "org.netbeans.ui.metrics.projects";
    private static final String J2SE_MODULAR_METRICS_LOGGER = "org.netbeans.ui.metrics.j2se-modular";
    private static SpecificationVersion defaultSourceLevel;

    private J2SEModularProjectGenerator() {
    }

    public static AntProjectHelper createProject(File dir, String name, JavaPlatform platform) throws IOException {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"name", (Object)name);
        FileObject dirFO = FileUtil.createFolder((File)dir);
        AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(() -> {
            SpecificationVersion sourceLevel = J2SEModularProjectGenerator.getSourceLevel(platform);
            h[0] = J2SEModularProjectGenerator.createProject(dirFO, name, sourceLevel, "src", "classes", "tests", (String)platform.getProperties().get(PROP_PLATFORM_ANT_NAME));
            J2SEModularProject p = (J2SEModularProject)ProjectManager.getDefault().findProject(dirFO);
            ProjectManager.getDefault().saveProject((Project)p);
            try {
                ProjectManager.mutex().writeAccess(() -> {
                    ProjectManager.getDefault().saveProject((Project)p);
                    ProjectUtils.getSources((Project)p).getSourceGroups("modules");
                    return null;
                });
            }
            catch (MutexException ex) {
                Exceptions.printStackTrace((Throwable)ex.getException());
            }
            dirFO.createFolder("src");
        });
        return h[0];
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, SpecificationVersion sourceLevel, String srcRoot, String srcRootPath, String testSrcRootPath, @NonNull String platformId) throws IOException {
        String antName = PropertyUtils.getUsablePropertyName((String)name);
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.java.j2semodule");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-modular-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        if (!DEFAULT_PLATFORM_ID.equals(platformId)) {
            Element platformEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-modular-project/1", "explicit-platform");
            platformEl.setAttribute("explicit-source-supported", "true");
            data.appendChild(platformEl);
        }
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-modular-project/1", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-modular-project/1", "root");
            root.setAttribute("id", "src.dir");
            root.setAttribute("pathref", "src.dir.path");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
            ep.setProperty("src.dir.path", srcRootPath);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-modular-project/1", "test-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-modular-project/1", "root");
            root.setAttribute("id", "test.src.dir");
            root.setAttribute("pathref", "test.src.dir.path");
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", srcRoot);
            ep.setProperty("test.src.dir.path", testSrcRootPath);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", "false");
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("annotation.processing.processor.options", "");
        ep.setProperty("dist.dir", "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("javac.classpath", "");
        ep.setProperty("javac.processorpath", new String[]{J2SEModularProjectGenerator.ref("javac.classpath", true)});
        ep.setProperty("javac.test.processorpath", new String[]{J2SEModularProjectGenerator.ref("javac.test.classpath", true)});
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", "");
        ep.setProperty("debug.classpath", new String[]{J2SEModularProjectGenerator.ref("run.classpath", true)});
        ep.setComment("debug.classpath", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_debug.transport"), "#debug.transport=dt_socket"}, false);
        ep.setProperty("jar.compress", "false");
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.test.classpath", new String[]{J2SEModularProjectGenerator.ref("javac.classpath", true)});
        ep.setProperty("run.test.classpath", new String[]{J2SEModularProjectGenerator.ref("javac.test.classpath", true)});
        ep.setProperty("debug.test.classpath", new String[]{J2SEModularProjectGenerator.ref("run.test.classpath", true)});
        ep.setProperty("javac.modulepath", "");
        ep.setProperty("javac.processormodulepath", "");
        ep.setProperty("run.modulepath", new String[]{J2SEModularProjectGenerator.ref("javac.modulepath", false), J2SEModularProjectGenerator.ref("build.modules.dir", true)});
        ep.setProperty("debug.modulepath", new String[]{J2SEModularProjectGenerator.ref("run.modulepath", true)});
        ep.setProperty("javac.test.modulepath", new String[]{J2SEModularProjectGenerator.ref("javac.modulepath", false), J2SEModularProjectGenerator.ref("build.modules.dir", true)});
        ep.setProperty("run.test.modulepath", new String[]{J2SEModularProjectGenerator.ref("javac.test.modulepath", false), J2SEModularProjectGenerator.ref("build.test.modules.dir", true)});
        ep.setProperty("debug.test.modulepath", new String[]{J2SEModularProjectGenerator.ref("run.test.modulepath", true)});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.modules.dir", "${build.dir}/modules");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.modules.dir", "${build.dir}/test/modules");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", platformId);
        ep.setProperty("run.jvmargs", "");
        ep.setComment("run.jvmargs", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_run.jvmargs"), "# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_run.jvmargs_2"), "# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_run.jvmargs_3")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.html5", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        ep.setProperty("dist.archive.excludes", "");
        ep.setComment("dist.archive.excludes", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_dist.archive.excludes")}, false);
        ep.setProperty("dist.jlink.dir", "${dist.dir}/jlink");
        ep.setProperty("dist.jlink.output", "${dist.jlink.dir}/" + antName);
        ep.setProperty("jlink.additionalmodules", "");
        ep.setComment("jlink.additionalmodules", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_jlink.additionalmodules")}, false);
        ep.setProperty("jlink.additionalparam", "");
        ep.setComment("jlink.additionalparam", new String[]{"# " + NbBundle.getMessage(J2SEModularProjectGenerator.class, (String)"COMMENT_jlink.additionalparam")}, false);
        ep.setProperty("jlink.launcher", "true");
        ep.setProperty("jlink.launcher.name", antName);
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("compile.on.save", "true");
        h.putProperties("nbproject/private/private.properties", ep);
        J2SEModularProjectGenerator.logUsage(Action.OPEN);
        return h;
    }

    private static SpecificationVersion getSourceLevel(JavaPlatform platform) {
        if (defaultSourceLevel != null) {
            return defaultSourceLevel;
        }
        return platform.getSpecification().getVersion();
    }

    private static String ref(@NonNull String propertyName, boolean lastEntry) {
        return String.format("${%s}%s", propertyName, lastEntry ? "" : ":");
    }

    static void logUsage(@NonNull Action action) {
        assert (action != null);
        Logger logger = Logger.getLogger(METRICS_LOGGER);
        LogRecord logRecord = new LogRecord(Level.INFO, action.getGenericLogMessage());
        logRecord.setLoggerName(logger.getName());
        logRecord.setParameters(new Object[]{"org.netbeans.modules.java.j2semodule"});
        logger.log(logRecord);
        logger = Logger.getLogger(J2SE_MODULAR_METRICS_LOGGER);
        logRecord = new LogRecord(Level.INFO, action.getSpecificLogMessage());
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }

    public static void setDefaultSourceLevel(SpecificationVersion version) {
        defaultSourceLevel = version;
    }

    static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action CREATE = new Action("USG_PROJECT_CREATE", "USG_PROJECT_CREATE_J2SE_MODULAR");
        public static final /* enum */ Action OPEN = new Action("USG_PROJECT_OPEN", "USG_PROJECT_OPEN_J2SE_MODULAR");
        public static final /* enum */ Action CLOSE = new Action("USG_PROJECT_CLOSE", "USG_PROJECT_CLOSE_J2SE_MODULAR");
        private final String genericLogMessage;
        private final String specificLogMessage;
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String name) {
            return Enum.valueOf(Action.class, name);
        }

        private Action(String genericLogMessage, String specificLogMessage) {
            assert (genericLogMessage != null);
            assert (specificLogMessage != null);
            this.genericLogMessage = genericLogMessage;
            this.specificLogMessage = specificLogMessage;
        }

        @NonNull
        public String getGenericLogMessage() {
            return this.genericLogMessage;
        }

        @NonNull
        public String getSpecificLogMessage() {
            return this.specificLogMessage;
        }

        private static /* synthetic */ Action[] $values() {
            return new Action[]{CREATE, OPEN, CLOSE};
        }

        static {
            $VALUES = Action.$values();
        }
    }
}

