/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cpplite.debugger.DebuggerAnnotation;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static Object currentLine;

    static synchronized void markCurrent(Object line) {
        Utils.unmarkCurrent();
        Annotatable[] annotatables = (Annotatable[])line;
        int i = 0;
        int k = annotatables.length;
        DebuggerAnnotation[] annotations = new DebuggerAnnotation[k];
        annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CurrentPCLinePart", annotatables[i]) : new DebuggerAnnotation("CurrentPC", annotatables[i]);
        for (i = 1; i < k; ++i) {
            annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CurrentPC2LinePart", annotatables[i]) : new DebuggerAnnotation("CurrentPC2", annotatables[i]);
        }
        currentLine = annotations;
        Utils.showLine(line);
    }

    static synchronized void unmarkCurrent() {
        if (currentLine != null) {
            int k = ((DebuggerAnnotation[])currentLine).length;
            for (int i = 0; i < k; ++i) {
                ((DebuggerAnnotation[])currentLine)[i].detach();
            }
            currentLine = null;
        }
    }

    public static void showLine(Object line) {
        final Annotatable[] a = (Annotatable[])line;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (a[0] instanceof Line) {
                    ((Line)a[0]).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                } else if (a[0] instanceof Line.Part) {
                    ((Line.Part)a[0]).getLine().show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                } else {
                    throw new InternalError(a[0].toString());
                }
            }
        });
    }

    static int getLineNumber(Object line) {
        Annotatable[] a = (Annotatable[])line;
        if (a[0] instanceof Line) {
            return ((Line)a[0]).getLineNumber();
        }
        if (a[0] instanceof Line.Part) {
            return ((Line.Part)a[0]).getLine().getLineNumber();
        }
        throw new InternalError();
    }

    public static boolean contains(Object currentLine, Line line) {
        if (currentLine == null) {
            return false;
        }
        Annotatable[] a = (Annotatable[])currentLine;
        int k = a.length;
        for (int i = 0; i < k; ++i) {
            if (a[i].equals(line)) {
                return true;
            }
            if (!(a[i] instanceof Line.Part) || !((Line.Part)a[i]).getLine().equals(line)) continue;
            return true;
        }
        return false;
    }
}

