/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class DiscreteProgress
extends JPanel {
    private Color disabledColor = new Color(220, 220, 220);
    private Color enabledColor = new Color(128, 128, 255);
    private int activeUnits = 0;
    private int totalUnits = 10;
    private int unitHeight = 13;
    private int unitWidth = 10;
    private JProgressBar progressDelegate;
    private DefaultBoundedRangeModel progressDelegateModel;

    public DiscreteProgress() {
        this.initComponents();
    }

    public void setActiveUnits(int activeUnits) {
        if (this.progressDelegateModel != null) {
            this.activeUnits = activeUnits;
            this.progressDelegateModel.setValue(activeUnits);
        } else if (this.activeUnits != activeUnits) {
            this.activeUnits = activeUnits;
            this.repaint();
        }
    }

    public int getActiveUnits() {
        return this.activeUnits;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.totalUnits * this.unitWidth + this.totalUnits - 1 + 4, this.unitHeight + 4);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DiscreteProgress progress = new DiscreteProgress();
        JFrame testFrame = new JFrame("Decimal Progress Test Frame");
        testFrame.getContentPane().add(progress);
        testFrame.setDefaultCloseOperation(3);
        testFrame.pack();
        testFrame.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.progressDelegate == null) {
            Insets insets = this.getInsets();
            int offsetX = insets.left;
            int offsetY = insets.top;
            for (int i = 0; i < this.totalUnits; ++i) {
                g.setColor(i < this.activeUnits ? this.enabledColor : this.disabledColor);
                g.fillRect(offsetX + i * this.unitWidth + i, offsetY, this.unitWidth, this.unitHeight);
            }
        } else {
            super.paintComponent(g);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.progressDelegateModel = new DefaultBoundedRangeModel(4, 1, 0, 10);
        this.progressDelegate = new JProgressBar(this.progressDelegateModel);
        this.add((Component)this.progressDelegate, "Center");
    }
}

