/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.customizer;

import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.javaee.api.ui.support.CheckBoxUpdater;
import org.netbeans.modules.gradle.javaee.api.ui.support.ComboBoxUpdater;
import org.netbeans.modules.gradle.javaee.api.ui.support.DisplayNameListCellRenderer;
import org.netbeans.modules.gradle.javaee.api.ui.support.JavaEEServerComboBoxModel;
import org.netbeans.modules.gradle.javaee.customizer.Bundle;
import org.netbeans.modules.gradle.javaee.web.WebModuleProviderImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomizerRunWar
extends JPanel {
    public static final String PROP_SHOW_IN_BROWSER = "netbeans.deploy.show";
    public static final String PROP_SHOW_PAGE = "netbeans.deploy.show.page";
    private final Project project;
    final ComboBoxUpdater serverUpdater;
    final CheckBoxUpdater showInBrowserUpdater;
    final BrowserUISupport.BrowserComboBoxModel browserModel;
    private JComboBox<WebBrowser> cbBrowser;
    private JCheckBox cbBrowserOnRun;
    private JComboBox<J2eePlatform> cbServer;
    private JLabel lbBrowser;
    private JLabel lbContextPath;
    private JLabel lbRelativeURL;
    private JLabel lbServer;
    private JLabel lbVersion;
    private JTextField tfContextPath;
    private JTextField tfRelativeURL;
    private JTextField tfVersion;

    public CustomizerRunWar(Project project) {
        this.project = project;
        this.initComponents();
        String instanceId = JavaEEProjectSettings.getServerInstanceID((Project)project);
        Profile profile = JavaEEProjectSettings.getProfile((Project)project);
        this.tfVersion.setText(profile != null ? profile.getDisplayName() : Bundle.NO_PROFILE());
        if (profile != null) {
            this.cbServer.setModel(JavaEEServerComboBoxModel.createJavaEEServerComboBoxModel(instanceId, J2eeModule.Type.WAR, profile));
            this.cbServer.setRenderer(new DisplayNameListCellRenderer<J2eePlatform>(this.cbServer.getRenderer()));
            this.serverUpdater = ComboBoxUpdater.create(this.cbServer, this.lbServer, this.getServer(instanceId), value -> {
                String serverId = JavaEEServerComboBoxModel.getServerInstanceID(this.cbServer.getItemAt(this.cbServer.getSelectedIndex()));
                JavaEEProjectSettings.setServerInstanceID((Project)project, (String)serverId);
            });
        } else {
            this.serverUpdater = null;
        }
        WebModuleProviderImpl moduleProviderImpl = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
        if (moduleProviderImpl != null) {
            this.tfContextPath.setText(moduleProviderImpl.getModuleImpl().getContextPath());
        }
        String selectedBrowser = JavaEEProjectSettings.getBrowserID((Project)project);
        this.browserModel = BrowserUISupport.createBrowserModel((String)selectedBrowser, (boolean)true);
        this.cbBrowser.setModel((ComboBoxModel<WebBrowser>)this.browserModel);
        this.cbBrowser.setRenderer(BrowserUISupport.createBrowserRenderer());
        Preferences prefs = NbGradleProject.getPreferences((Project)project, (boolean)false);
        Boolean showInBrowser = prefs.getBoolean(PROP_SHOW_IN_BROWSER, true);
        this.showInBrowserUpdater = CheckBoxUpdater.create(this.cbBrowserOnRun, showInBrowser, value -> {
            boolean show = this.cbBrowserOnRun.isSelected();
            prefs.putBoolean(PROP_SHOW_IN_BROWSER, show);
            prefs.put(PROP_SHOW_PAGE, this.tfRelativeURL.getText().trim());
        });
        String relativeUrl = prefs.get(PROP_SHOW_PAGE, "");
        this.tfRelativeURL.setText(relativeUrl);
    }

    private void saveContextPath() {
        String newPath = this.tfContextPath.getText().trim();
        WebModuleProviderImpl moduleProviderImpl = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
        if (moduleProviderImpl != null && !newPath.equals(moduleProviderImpl.getModuleImpl().getContextPath())) {
            moduleProviderImpl.getModuleImpl().setContextPath(newPath);
        }
    }

    void save() {
        if (this.serverUpdater != null) {
            this.serverUpdater.storeValue();
        }
        this.showInBrowserUpdater.storeValue();
        this.saveContextPath();
        JavaEEProjectSettings.setBrowserID((Project)this.project, (String)this.browserModel.getSelectedBrowserId());
    }

    private void initComponents() {
        this.lbServer = new JLabel();
        this.cbServer = new JComboBox();
        this.lbVersion = new JLabel();
        this.lbContextPath = new JLabel();
        this.lbRelativeURL = new JLabel();
        this.lbBrowser = new JLabel();
        this.cbBrowserOnRun = new JCheckBox();
        this.tfContextPath = new JTextField();
        this.tfRelativeURL = new JTextField();
        this.cbBrowser = new JComboBox();
        this.tfVersion = new JTextField();
        this.lbServer.setLabelFor(this.cbServer);
        Mnemonics.setLocalizedText((JLabel)this.lbServer, (String)NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.lbServer.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbVersion, (String)NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.lbVersion.text"));
        this.lbContextPath.setLabelFor(this.tfContextPath);
        Mnemonics.setLocalizedText((JLabel)this.lbContextPath, (String)NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.lbContextPath.text"));
        this.lbRelativeURL.setLabelFor(this.tfRelativeURL);
        Mnemonics.setLocalizedText((JLabel)this.lbRelativeURL, (String)NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.lbRelativeURL.text"));
        this.lbBrowser.setLabelFor(this.cbBrowser);
        Mnemonics.setLocalizedText((JLabel)this.lbBrowser, (String)NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.lbBrowser.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbBrowserOnRun, (String)NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.cbBrowserOnRun.text"));
        this.tfContextPath.setText(NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.tfContextPath.text"));
        this.tfRelativeURL.setText(NbBundle.getMessage(CustomizerRunWar.class, (String)"CustomizerRunWar.tfRelativeURL.text"));
        this.tfVersion.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbVersion, -1, -1, Short.MAX_VALUE).addComponent(this.lbServer, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbServer, 0, -1, Short.MAX_VALUE).addComponent(this.tfVersion))).addGroup(layout.createSequentialGroup().addComponent(this.lbContextPath, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfContextPath)).addGroup(layout.createSequentialGroup().addComponent(this.lbBrowser, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBrowser, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.lbRelativeURL, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfRelativeURL, -2, 276, -2)).addComponent(this.cbBrowserOnRun)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.linkSize(0, this.lbBrowser, this.lbContextPath, this.lbRelativeURL, this.lbVersion);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbServer).addComponent(this.cbServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbVersion).addComponent(this.tfVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbContextPath).addComponent(this.tfContextPath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBrowserOnRun, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbRelativeURL).addComponent(this.tfRelativeURL, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbBrowser).addComponent(this.cbBrowser, -2, -1, -2)).addContainerGap(110, Short.MAX_VALUE)));
    }

    private J2eePlatform getServer(String id) {
        if (id == null) {
            return null;
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(id);
        try {
            return serverInstance != null ? serverInstance.getJ2eePlatform() : null;
        }
        catch (InstanceRemovedException ex) {
            return null;
        }
    }
}

