/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.apigen.ui;

import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.apigen.ui.BrowseFolderPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ApiGenPreferences {
    public static final Property<String> TITLE = new Property<String>("title"){

        @Override
        public String getDefaultValue(PhpModule phpModule) {
            return phpModule.getDisplayName();
        }
    };
    public static final Property<String> CONFIG = new Property<String>("config"){

        @Override
        public String getDefaultValue(PhpModule phpModule) {
            List<FileObject> dirs = Arrays.asList(phpModule.getProjectDirectory(), phpModule.getSourceDirectory());
            for (FileObject dir : dirs) {
                FileObject config = dir.getFileObject("apigen.neon");
                if (config == null || !config.isData()) continue;
                return FileUtil.toFile((FileObject)config).getAbsolutePath();
            }
            return null;
        }
    };
    public static final Property<String> CHARSETS = new Property<String>("charsets"){

        @Override
        public String getDefaultValue(PhpModule phpModule) {
            return ((PhpModuleProperties.Factory)phpModule.getLookup().lookup(PhpModuleProperties.Factory.class)).getProperties().getEncoding();
        }
    };
    public static final Property<String> EXCLUDES = new Property("excludes");
    public static final Property<String> ACCESS_LEVELS = new Property<String>("accessLevels"){

        @Override
        public String getDefaultValue(PhpModule phpModule) {
            return "public,protected";
        }
    };
    public static final Property<Boolean> INTERNAL = new Property<Boolean>("internal"){

        @Override
        public Boolean getDefaultValue(PhpModule phpModule) {
            return false;
        }
    };
    public static final Property<Boolean> PHP = new Property<Boolean>("php"){

        @Override
        public Boolean getDefaultValue(PhpModule phpModule) {
            return true;
        }
    };
    public static final Property<Boolean> TREE = new Property<Boolean>("tree"){

        @Override
        public Boolean getDefaultValue(PhpModule phpModule) {
            return true;
        }
    };
    public static final Property<Boolean> DEPRECATED = new Property<Boolean>("deprecated"){

        @Override
        public Boolean getDefaultValue(PhpModule phpModule) {
            return false;
        }
    };
    public static final Property<Boolean> TODO = new Property<Boolean>("todo"){

        @Override
        public Boolean getDefaultValue(PhpModule phpModule) {
            return false;
        }
    };
    public static final Property<Boolean> DOWNLOAD = new Property<Boolean>("download"){

        @Override
        public Boolean getDefaultValue(PhpModule phpModule) {
            return false;
        }
    };
    public static final Property<Boolean> SOURCE_CODE = new Property<Boolean>("sourceCode"){

        @Override
        public Boolean getDefaultValue(PhpModule phpModule) {
            return true;
        }
    };
    public static final Property<Boolean> HAS_CONFIG = new Property("hasConfig");
    static final Property<Object> TARGET = new Property("target");
    private static final String ENABLED = "enabled";
    private static final String SEPARATOR = ",";

    private ApiGenPreferences() {
    }

    public static boolean isEnabled(PhpModule phpModule) {
        return ApiGenPreferences.getPreferences(phpModule).getBoolean(ENABLED, false);
    }

    public static void setEnabled(PhpModule phpModule, boolean enabled) {
        ApiGenPreferences.getPreferences(phpModule).putBoolean(ENABLED, enabled);
    }

    public static String getTarget(PhpModule phpModule, boolean showPanel) {
        String target = ApiGenPreferences.get(phpModule, TARGET);
        if (StringUtils.isEmpty((String)target) && showPanel) {
            target = BrowseFolderPanel.open(phpModule);
            if (target == null) {
                return null;
            }
            ApiGenPreferences.put(phpModule, TARGET, target);
        }
        return target;
    }

    public static void putTarget(PhpModule phpModule, String target) {
        ApiGenPreferences.put(phpModule, TARGET, target);
    }

    public static String get(PhpModule phpModule, Property<? extends Object> property) {
        String value = ApiGenPreferences.getPreferences(phpModule).get(property.getKey(), null);
        if (value == null) {
            Object defaultValue = property.getDefaultValue(phpModule);
            if (defaultValue == null) {
                return null;
            }
            return defaultValue.toString();
        }
        return value;
    }

    public static List<String> getMore(PhpModule phpModule, Property<? extends Object> property) {
        return StringUtils.explode((String)ApiGenPreferences.get(phpModule, property), (String)SEPARATOR);
    }

    public static boolean getBoolean(PhpModule phpModule, Property<Boolean> property) {
        return Boolean.parseBoolean(ApiGenPreferences.get(phpModule, property));
    }

    public static void put(PhpModule phpModule, Property<? extends Object> property, @NullAllowed String value) {
        if (value == null) {
            ApiGenPreferences.getPreferences(phpModule).remove(property.getKey());
        } else {
            ApiGenPreferences.getPreferences(phpModule).put(property.getKey(), value);
        }
    }

    public static void putMore(PhpModule phpModule, Property<? extends Object> property, @NullAllowed List<String> values) {
        if (values == null) {
            ApiGenPreferences.put(phpModule, property, null);
        } else {
            ApiGenPreferences.put(phpModule, property, StringUtils.implode(values, (String)SEPARATOR));
        }
    }

    public static void putBoolean(PhpModule phpModule, Property<Boolean> property, boolean value) {
        ApiGenPreferences.put(phpModule, property, Boolean.toString(value));
    }

    private static Preferences getPreferences(PhpModule phpModule) {
        return phpModule.getPreferences(ApiGenPreferences.class, false);
    }

    public static class Property<T> {
        private final String key;

        private Property(String key) {
            assert (key != null);
            this.key = key;
        }

        String getKey() {
            return this.key;
        }

        public T getDefaultValue(PhpModule phpModule) {
            return null;
        }
    }
}

