/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.Strings;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.xml.multiview.Error;
import org.openide.filesystems.FileObject;

public class PersistenceValidator {
    private final PUDataObject puDataObject;
    private List<Error> errors = new ArrayList<Error>();

    public PersistenceValidator(PUDataObject puDataObject) {
        this.puDataObject = puDataObject;
    }

    public List<Error> validate() {
        this.validateName();
        this.validateExcludeUnlisted();
        this.validateJarFiles();
        return this.errors;
    }

    private void validateName() {
        PersistenceUnit[] persistenceUnits = this.puDataObject.getPersistence().getPersistenceUnit();
        for (int i = 0; i < persistenceUnits.length; ++i) {
            String title = persistenceUnits[i].getName();
            if (Strings.isEmpty((String)title)) {
                Error.ErrorLocation loc = new Error.ErrorLocation((Object)persistenceUnits[i], "name");
                this.errors.add(new Error(2, "name", loc));
            }
            for (int j = 0; j < persistenceUnits.length; ++j) {
                String tit = persistenceUnits[j].getName();
                if (Strings.isEmpty((String)title) || i == j || !title.equals(tit)) continue;
                Error.ErrorLocation loc = new Error.ErrorLocation((Object)persistenceUnits[i], "name");
                this.errors.add(new Error(0, 3, title, loc));
            }
        }
    }

    private void validateExcludeUnlisted() {
        if (!this.isJavaSE()) {
            return;
        }
        PersistenceUnit[] persistenceUnits = this.puDataObject.getPersistence().getPersistenceUnit();
        for (int i = 0; i < persistenceUnits.length; ++i) {
            if (!persistenceUnits[i].isExcludeUnlistedClasses()) continue;
            Error.ErrorLocation loc = new Error.ErrorLocation((Object)persistenceUnits[i], "exclude-unlisted-classes");
            this.errors.add(new Error(0, 1, "exclude-unlisted-classes property is not supported in Java SE environments", loc));
        }
    }

    private void validateJarFiles() {
        if (!this.isJavaSE()) {
            return;
        }
        PersistenceUnit[] persistenceUnits = this.puDataObject.getPersistence().getPersistenceUnit();
        for (int i = 0; i < persistenceUnits.length; ++i) {
            if (persistenceUnits[i].getJarFile() == null || persistenceUnits[i].getJarFile().length <= 0) continue;
            Error.ErrorLocation loc = new Error.ErrorLocation((Object)persistenceUnits[i], "jar-files");
            this.errors.add(new Error(0, 1, "jar-files property is not supported in Java SE environments", loc));
        }
    }

    protected boolean isJavaSE() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.puDataObject.getPrimaryFile());
        return Util.isJavaSE(project);
    }
}

