/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.spi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.layers.LayerFileSystem;
import org.netbeans.modules.apisupport.project.layers.SynchronousStatus;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.StatusDecorator;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Utilities;

public class LayerUtil {
    private static final Set<String> XML_LIKE_TYPES = new HashSet<String>();
    public static final String HIDDEN = "_hidden";
    public static final String LAYER_ICON = "org/netbeans/modules/apisupport/project/spi/layerObject.gif";

    @NonNull
    public static FileSystem mergeFilesystems(FileSystem writableLayer, Collection<FileSystem> readOnlyLayers) {
        if (writableLayer == null) {
            writableLayer = new XMLFileSystem();
        }
        FileSystem[] layers = new FileSystem[readOnlyLayers.size() + 1];
        layers[0] = writableLayer;
        Iterator<FileSystem> it = readOnlyLayers.iterator();
        int i = 1;
        while (it.hasNext()) {
            layers[i] = it.next();
            ++i;
        }
        return new LayerFileSystem(layers);
    }

    public static List<URL> layersOf(File jar) throws IOException {
        ManifestManager mm = ManifestManager.getInstanceFromJAR(jar, true);
        for (String tok : mm.getRequiredTokens()) {
            if (!tok.startsWith("org.openide.modules.os.")) continue;
            return Collections.emptyList();
        }
        String layer = mm.getLayer();
        String generatedLayer = mm.getGeneratedLayer();
        ArrayList<URL> urls = new ArrayList<URL>(2);
        URI juri = Utilities.toURI((File)jar);
        for (String path : new String[]{layer, generatedLayer}) {
            if (path == null) continue;
            urls.add(new URL("jar:" + juri + "!/" + path));
        }
        if (layer != null) {
            urls.add(new URL("jar:" + juri + "!/" + layer));
        }
        if (generatedLayer != null) {
            urls.add(new URL("jar:" + juri + "!/" + generatedLayer));
        }
        return urls;
    }

    public static String generateBundleKeyForFile(String filePath) {
        return filePath.replaceAll("[^-a-zA-Z0-9_./]", "");
    }

    public static String findGeneratedName(FileObject parent, String layerPath) {
        Matcher m = Pattern.compile("(.+/)?([^/.]+)(\\.[^/]+)?").matcher(layerPath);
        if (!m.matches()) {
            throw new IllegalArgumentException(layerPath);
        }
        String base = m.group(2);
        String ext = m.group(3);
        if (ext == null) {
            ext = "";
        } else if (ext.equals(".java")) {
            ext = "_java";
        } else if (XML_LIKE_TYPES.contains(ext)) {
            String upper = ext.substring(1, 2).toUpperCase(Locale.ENGLISH);
            base = base + upper + ext.substring(2);
            ext = ".xml";
        }
        String name = base + ext;
        if (parent == null || parent.getFileObject(name) == null) {
            return name;
        }
        int i = 1;
        while (parent.getFileObject(name = base + '_' + i + ext) != null) {
            ++i;
        }
        return name;
    }

    public static String getAnnotatedName(FileObject fo) {
        String name = fo.getNameExt();
        try {
            StatusDecorator status = fo.getFileSystem().getDecorator();
            if (status instanceof SynchronousStatus) {
                return ((SynchronousStatus)status).annotateNameSynch(name, Collections.singleton(fo));
            }
            return status.annotateName(name, Collections.singleton(fo));
        }
        catch (FileStateInvalidException ex) {
            return name;
        }
    }

    private LayerUtil() {
    }

    static {
        XML_LIKE_TYPES.add(".settings");
        XML_LIKE_TYPES.add(".wstcref");
        XML_LIKE_TYPES.add(".wsmode");
        XML_LIKE_TYPES.add(".wsgrp");
        XML_LIKE_TYPES.add(".wsmgr");
    }
}

