/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.layers.PickNameAction;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;

public class PickIconAction
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        FileObject f = PickNameAction.findFile(activatedNodes);
        if (f == null) {
            return;
        }
        NbModuleProvider p = PickNameAction.findProject(f);
        if (p == null) {
            return;
        }
        FileObject src = p.getSourceDirectory();
        JFileChooser chooser = UIUtil.getIconFileChooser();
        chooser.setCurrentDirectory(FileUtil.toFile((FileObject)src));
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) != 0) {
            return;
        }
        FileObject icon = FileUtil.toFileObject((File)chooser.getSelectedFile());
        String iconPath = FileUtil.getRelativePath((FileObject)src, (FileObject)icon);
        try {
            if (iconPath == null) {
                String layerPath = ManifestManager.getInstance(Util.getManifest(p.getManifestFile()), false).getLayer();
                String folderPath = layerPath != null ? layerPath.substring(0, layerPath.lastIndexOf(47)) : p.getCodeNameBase().replace('.', '/') + "/resources";
                FileObject folder = FileUtil.createFolder((FileObject)src, (String)folderPath);
                FileUtil.copyFile((FileObject)icon, (FileObject)folder, (String)icon.getName(), (String)icon.getExt());
                iconPath = folderPath + '/' + icon.getNameExt();
            }
            f.setAttribute("iconBase", (Object)iconPath);
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!super.enable(activatedNodes)) {
            return false;
        }
        FileObject f = PickNameAction.findFile(activatedNodes);
        if (f == null) {
            return false;
        }
        NbModuleProvider p = PickNameAction.findProject(f);
        return p != null;
    }

    public String getName() {
        return NbBundle.getMessage(PickIconAction.class, (String)"LBL_pick_icon");
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

