/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorCodeSnifferParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.CodeSnifferStandardsComboBoxModel;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.Bundle;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CodeSnifferOptionsPanel
extends AnalysisCategoryPanel {
    private static final long serialVersionUID = 1342405149329523117L;
    final CodeSnifferStandardsComboBoxModel codeSnifferStandardsModel = new CodeSnifferStandardsComboBoxModel();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    volatile boolean ignoreChanges = false;
    private JButton codeSnifferBrowseButton;
    private JLabel codeSnifferHintLabel;
    private JLabel codeSnifferLabel;
    private JLabel codeSnifferLearnMoreLabel;
    private JButton codeSnifferSearchButton;
    private JComboBox<String> codeSnifferStandardComboBox;
    private JLabel codeSnifferStandardLabel;
    private JTextField codeSnifferTextField;
    private JLabel minVersionInfoLabel;
    private JLabel noteLabel;

    public CodeSnifferOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        AnalysisDefaultDocumentListener defaultDocumentListener = new AnalysisDefaultDocumentListener(() -> this.fireChange());
        this.initCodeSniffer(defaultDocumentListener);
    }

    private void initCodeSniffer(DocumentListener defaultDocumentListener) {
        this.codeSnifferHintLabel.setText(Bundle.CodeSnifferOptionsPanel_hint("phpcs", CodeSniffer.LONG_NAME));
        this.codeSnifferStandardComboBox.setModel(this.codeSnifferStandardsModel);
        this.codeSnifferTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.codeSnifferTextField.getDocument().addDocumentListener(new CodeSnifferPathDocumentListener());
        final DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.codeSnifferStandardsModel.fetchStandards(this.codeSnifferStandardComboBox, new Runnable(){
            final /* synthetic */ CodeSnifferOptionsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.codeSnifferStandardComboBox.addItemListener(defaultItemListener);
            }
        });
    }

    void setStandards(String selectedCodeSnifferStandard, String customCodeSnifferPath) {
        this.codeSnifferStandardsModel.fetchStandards(this.codeSnifferStandardComboBox, customCodeSnifferPath, null);
        this.codeSnifferStandardsModel.setSelectedItem(selectedCodeSnifferStandard);
    }

    public String getCodeSnifferPath() {
        return this.codeSnifferTextField.getText();
    }

    public void setCodeSnifferPath(String path) {
        this.ignoreChanges = true;
        this.codeSnifferTextField.setText(path);
        this.ignoreChanges = false;
    }

    @CheckForNull
    public String getCodeSnifferStandard() {
        if (!this.codeSnifferStandardComboBox.isEnabled()) {
            return null;
        }
        return this.codeSnifferStandardsModel.getSelectedStandard();
    }

    public void setCodeSnifferStandard(String standard) {
        this.codeSnifferStandardsModel.setSelectedItem(standard);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    @Override
    public String getCategoryName() {
        return Bundle.CodeSnifferOptionsPanel_category_name();
    }

    @Override
    public void update() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        this.setCodeSnifferPath(analysisOptions.getCodeSnifferPath());
        this.setCodeSnifferStandard(analysisOptions.getCodeSnifferStandard());
    }

    @Override
    public void applyChanges() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        analysisOptions.setCodeSnifferPath(this.getCodeSnifferPath());
        analysisOptions.setCodeSnifferStandard(this.getCodeSnifferStandard());
    }

    @Override
    public boolean isChanged() {
        String saved = AnalysisOptions.getInstance().getCodeSnifferPath();
        String current = this.getCodeSnifferPath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodeSnifferStandard();
        current = this.getCodeSnifferStandard();
        if (saved == null) {
            if (current == null) {
                return false;
            }
            return !current.trim().isEmpty();
        }
        return current == null ? !saved.trim().isEmpty() : !saved.equals(current);
    }

    @Override
    public ValidationResult getValidationResult() {
        return new AnalysisOptionsValidator().validateCodeSniffer(ValidatorCodeSnifferParameter.create(this)).getResult();
    }

    private void initComponents() {
        this.codeSnifferLabel = new JLabel();
        this.codeSnifferTextField = new JTextField();
        this.codeSnifferBrowseButton = new JButton();
        this.codeSnifferSearchButton = new JButton();
        this.codeSnifferHintLabel = new JLabel();
        this.codeSnifferStandardLabel = new JLabel();
        this.codeSnifferStandardComboBox = new JComboBox();
        this.noteLabel = new JLabel();
        this.minVersionInfoLabel = new JLabel();
        this.codeSnifferLearnMoreLabel = new JLabel();
        this.codeSnifferLabel.setLabelFor(this.codeSnifferTextField);
        Mnemonics.setLocalizedText((JLabel)this.codeSnifferLabel, (String)NbBundle.getMessage(CodeSnifferOptionsPanel.class, (String)"CodeSnifferOptionsPanel.codeSnifferLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeSnifferBrowseButton, (String)NbBundle.getMessage(CodeSnifferOptionsPanel.class, (String)"CodeSnifferOptionsPanel.codeSnifferBrowseButton.text"));
        this.codeSnifferBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeSnifferOptionsPanel.this.codeSnifferBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.codeSnifferSearchButton, (String)NbBundle.getMessage(CodeSnifferOptionsPanel.class, (String)"CodeSnifferOptionsPanel.codeSnifferSearchButton.text"));
        this.codeSnifferSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeSnifferOptionsPanel.this.codeSnifferSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.codeSnifferHintLabel, (String)"HINT");
        this.codeSnifferStandardLabel.setLabelFor(this.codeSnifferStandardComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codeSnifferStandardLabel, (String)NbBundle.getMessage(CodeSnifferOptionsPanel.class, (String)"CodeSnifferOptionsPanel.codeSnifferStandardLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(CodeSnifferOptionsPanel.class, (String)"CodeSnifferOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.minVersionInfoLabel, (String)NbBundle.getMessage(CodeSnifferOptionsPanel.class, (String)"CodeSnifferOptionsPanel.minVersionInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.codeSnifferLearnMoreLabel, (String)NbBundle.getMessage(CodeSnifferOptionsPanel.class, (String)"CodeSnifferOptionsPanel.codeSnifferLearnMoreLabel.text"));
        this.codeSnifferLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CodeSnifferOptionsPanel.this.codeSnifferLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CodeSnifferOptionsPanel.this.codeSnifferLearnMoreLabelMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.codeSnifferLearnMoreLabel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codeSnifferLabel).addComponent(this.codeSnifferStandardLabel)).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.codeSnifferTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeSnifferBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeSnifferSearchButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codeSnifferHintLabel).addComponent(this.codeSnifferStandardComboBox, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.minVersionInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.codeSnifferBrowseButton, this.codeSnifferSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codeSnifferLabel).addComponent(this.codeSnifferTextField, -2, -1, -2).addComponent(this.codeSnifferSearchButton).addComponent(this.codeSnifferBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeSnifferHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codeSnifferStandardComboBox, -2, -1, -2).addComponent(this.codeSnifferStandardLabel)).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeSnifferLearnMoreLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void codeSnifferBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseCodeSniffer();
        if (file != null) {
            this.codeSnifferTextField.setText(file.getAbsolutePath());
        }
    }

    private void codeSnifferSearchButtonActionPerformed(ActionEvent evt) {
        String codeSniffer = AnalysisUiUtils.searchCodeSniffer();
        if (codeSniffer != null) {
            this.codeSnifferTextField.setText(codeSniffer);
        }
    }

    private void codeSnifferLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void codeSnifferLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/squizlabs/PHP_CodeSniffer");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class CodeSnifferPathDocumentListener
    implements DocumentListener {
        private CodeSnifferPathDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            if (CodeSnifferOptionsPanel.this.ignoreChanges) {
                return;
            }
            String codeSnifferPath = CodeSnifferOptionsPanel.this.getCodeSnifferPath();
            ValidationResult result = new AnalysisOptionsValidator().validateCodeSnifferPath(codeSnifferPath).getResult();
            if (!result.hasErrors() && !result.hasWarnings()) {
                CodeSniffer.clearCachedStandards();
                CodeSnifferOptionsPanel.this.setStandards(CodeSnifferOptionsPanel.this.getCodeSnifferStandard(), codeSnifferPath);
            }
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CodeSnifferOptionsPanel.this.fireChange();
        }
    }
}

