/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.State;
import org.netbeans.lib.terminalemulator.Term;

class Sel
implements ClipboardOwner {
    private static final int SEL_NONE = 0;
    private static final int SEL_CHAR = 1;
    private static final int SEL_WORD = 2;
    private static final int SEL_LINE = 3;
    public static final int INT_NONE = 0;
    public static final int INT_ABOVE = 1;
    public static final int INT_ON = 2;
    public static final int INT_STRADDLES = 3;
    public static final int INT_BELOW = 4;
    private int sel_tracking;
    private int old_sel_tracking;
    private Coord sel_origin;
    public Coord sel_extent;
    private Extent initial_word;
    private Term term;
    private State state;
    private Color color = new Color(204, 204, 255);
    private Color xor_color = Color.white;

    void setColor(Color color) {
        this.color = color;
    }

    Color getColor() {
        return this.color;
    }

    void setXORColor(Color color) {
        this.xor_color = color;
    }

    Color getXORColor() {
        return this.xor_color;
    }

    Sel(Term term, State state) {
        this.term = term;
        this.state = state;
    }

    void adjust(int afirstline, int amount, int alastline) {
        if (this.sel_origin == null) {
            return;
        }
        if (this.sel_origin.compareTo(this.sel_extent) >= 0) {
            this.sel_extent.row += amount;
            if (this.sel_extent.row < afirstline) {
                this.sel_extent.row = afirstline;
            }
            this.sel_origin.row += amount;
            if (this.sel_origin.row >= alastline) {
                this.sel_origin.row = alastline - 1;
                this.sel_origin.col = this.term.buf().totalCols();
            }
            if (this.sel_origin.row < afirstline || this.sel_extent.row > alastline) {
                this.sel_extent = null;
                this.sel_origin = null;
            }
        } else {
            this.sel_origin.row += amount;
            if (this.sel_origin.row < afirstline) {
                this.sel_origin.row = afirstline;
            }
            this.sel_extent.row += amount;
            if (this.sel_extent.row >= alastline) {
                this.sel_extent.row = alastline - 1;
                this.sel_extent.col = this.term.buf().totalCols();
            }
            if (this.sel_extent.row < afirstline || this.sel_origin.row > alastline) {
                this.sel_origin = null;
                this.sel_extent = null;
            }
        }
        this.term.fireSelectionExtentChanged();
    }

    void relocate(int from, int to) {
        if (this.sel_origin == null) {
            return;
        }
        int delta = to - from;
        this.sel_origin.row += delta;
        this.sel_extent.row += delta;
    }

    Extent getExtent() {
        if (this.sel_origin == null) {
            return null;
        }
        Extent x = new Extent(this.sel_origin, this.sel_extent);
        x.order();
        return x;
    }

    void setExtent(Extent extent) {
        this.cancel(false);
        extent.order();
        this.sel_origin = (Coord)extent.begin.clone();
        this.sel_extent = (Coord)extent.end.clone();
        this.done();
    }

    public void select_word(Extent range) {
        this.sel_origin = new Coord(range.begin);
        this.sel_extent = new Coord(range.end);
        this.sel_tracking = 2;
        this.old_sel_tracking = 0;
        this.initial_word = range;
    }

    public void select_line(Coord coord) {
        this.sel_origin = Coord.make(coord.row, 0);
        this.sel_extent = Coord.make(coord.row, this.term.buf().totalCols());
        this.sel_tracking = 3;
        this.old_sel_tracking = 0;
    }

    public void select_line(Extent range) {
        this.sel_origin = new Coord(range.begin);
        this.sel_extent = new Coord(range.end);
        this.sel_tracking = 3;
        this.old_sel_tracking = 0;
    }

    private boolean extend_work(Coord p, int tracking) {
        if (tracking == 0) {
            return false;
        }
        if (tracking == 1) {
            this.sel_extent = p;
        } else if (tracking == 2) {
            BExtent Bnew_range = this.term.buf().find_word(this.term.getWordDelineator(), p.toBCoord(this.term.firsta()));
            Extent new_range = Bnew_range.toExtent(this.term.firsta());
            if (p.compareTo(this.initial_word.begin) < 0) {
                this.sel_origin = new Coord(new_range.begin);
                this.sel_extent = this.initial_word.end;
            } else if (p.compareTo(this.initial_word.end) > 0) {
                this.sel_origin = this.initial_word.begin;
                this.sel_extent = new Coord(new_range.end);
            } else {
                this.sel_origin = this.initial_word.begin;
                this.sel_extent = this.initial_word.end;
            }
        } else if (tracking == 3) {
            if (p.compareTo(this.sel_origin) > 0) {
                this.sel_origin = Coord.make(this.sel_origin.row, 0);
                this.sel_extent = Coord.make(p.row, this.term.buf().totalCols());
            } else {
                this.sel_origin = Coord.make(this.sel_origin.row, this.term.buf().totalCols());
                this.sel_extent = Coord.make(p.row, 0);
            }
        }
        return true;
    }

    public void track(Coord p) {
        if (this.sel_tracking == 0) {
            this.sel_origin = p;
            this.sel_extent = p;
            this.sel_tracking = 1;
            this.old_sel_tracking = 0;
        }
        this.extend_work(p, this.sel_tracking);
    }

    public boolean extend(Coord p) {
        if (this.sel_origin == null) {
            return false;
        }
        return this.extend_work(p, this.old_sel_tracking);
    }

    private boolean cancelHelp(boolean and_fire) {
        if (this.sel_origin == null) {
            return false;
        }
        this.old_sel_tracking = 0;
        this.sel_tracking = 0;
        this.sel_origin = null;
        this.sel_extent = null;
        this.initial_word = null;
        if (and_fire) {
            this.term.fireSelectionExtentChanged();
        }
        return true;
    }

    public boolean cancel(boolean and_fire) {
        if (!this.cancelHelp(and_fire)) {
            return false;
        }
        this.term.copyToSelection();
        return true;
    }

    public void done() {
        this.old_sel_tracking = this.sel_tracking;
        this.sel_tracking = 0;
        this.term.copyToSelection();
        this.term.fireSelectionExtentChanged();
    }

    @Override
    public void lostOwnership(Clipboard cb, Transferable c) {
        if (this.cancelHelp(true)) {
            this.term.repaint(false);
        }
    }

    public String getSelection() {
        Extent x = this.getExtent();
        if (x == null) {
            return null;
        }
        if (x.begin != null && x.end != null) {
            final StringBuffer text = new StringBuffer();
            this.term.visitLines(x.begin, x.end, true, new LineVisitor(){
                final /* synthetic */ Sel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean visit(Line l, int row, int bcol, int ecol) {
                    text.append(l.text(bcol, ecol));
                    return true;
                }
            });
            return text.toString();
        }
        return "";
    }

    int intersection(int line) {
        Extent x = this.getExtent();
        if (x == null) {
            return 0;
        }
        x.order();
        if (x.end.row < line) {
            return 1;
        }
        if (x.end.row == line) {
            return 2;
        }
        if (x.begin.row > line) {
            return 4;
        }
        return 3;
    }

    private void paint(Graphics g, int row, int bcol, int ecol) {
        if (row < this.state.firstx) {
            return;
        }
        if (row > this.state.firstx + this.state.rows) {
            return;
        }
        BCoord begin = new BCoord(row, bcol);
        BCoord end = new BCoord(row, ecol);
        begin = this.term.toViewCoord(begin);
        end = this.term.toViewCoord(end);
        if (begin == null || end == null) {
            return;
        }
        Line l = this.term.buf().lineAt(row);
        byte lw = l.width(this.term.metrics(), ecol);
        Point pbegin = this.term.toPixel(begin);
        Point pend = this.term.toPixel(end);
        pend.y += this.term.metrics().height;
        pend.x += this.term.metrics().width * lw;
        Dimension dim = new Dimension(pend.x - pbegin.x, pend.y - pbegin.y);
        Rectangle rect = new Rectangle(pbegin, dim);
        if (this.term.isSelectionXOR()) {
            g.setXORMode(this.xor_color);
        } else {
            g.setColor(this.color);
        }
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    void paint(final Graphics g) {
        Extent x = this.getExtent();
        if (x == null) {
            return;
        }
        x.order();
        this.term.visitLines(x.begin, x.end, true, new LineVisitor(){
            final /* synthetic */ Sel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visit(Line l, int row, int bcol, int ecol) {
                this.this$0.paint(g, row, bcol, ecol);
                return true;
            }
        });
    }
}

