/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public final class ContainerRepositoryItem
extends OCIItem
implements URLProvider {
    private Boolean isPublic;
    private Integer imageCount;
    private String namespace;

    public ContainerRepositoryItem(OCID id, String compartmentId, String name, String regionCode, String namespace, Boolean isPublic, Integer imageCount, String tenancyId) {
        super(id, compartmentId, name, tenancyId, regionCode);
        this.namespace = namespace;
        this.isPublic = isPublic;
        this.imageCount = imageCount;
    }

    public ContainerRepositoryItem() {
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public Integer getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(Integer imageCount) {
        this.imageCount = imageCount;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUrl() {
        return String.format("%s.ocir.io/%s/%s", this.getRegionCode(), this.getNamespace(), this.getName());
    }

    public String getRegistry() {
        return String.format("%s.ocir.io", this.getRegionCode());
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/compute/registry/containers?region=%s", this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

