/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.bucket;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public final class BucketItem
extends OCIItem
implements URLProvider {
    private String namespace;

    public BucketItem(OCID id, String compartmentId, String name, String namespace, String tenancyId, String regionCode) {
        super(id, compartmentId, name, tenancyId, regionCode);
        this.namespace = namespace;
    }

    public BucketItem() {
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public int maxInProject() {
        return Integer.MAX_VALUE;
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/object-storage/buckets/%s/%s/objects?region=%s", this.getNamespace(), this.getName(), this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

