/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.CreateContainerRepositoryCommand;
import org.netbeans.modules.cloud.oracle.actions.OCIItemCreator;
import org.netbeans.modules.cloud.oracle.assets.OpenProjectsFinder;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.requests.ContainerRepositoryRequest;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class CreateContainerRepository
implements OCIItemCreator {
    private static final String REPOSITORY_NAME_FIELD = "name";

    @Override
    public CompletableFuture<? extends OCIItem> create(Steps.Values values, Map<String, Object> params) {
        CompartmentItem compartment = (CompartmentItem)values.getValueForStep(CompartmentStep.class);
        String displayName = (String)params.get(REPOSITORY_NAME_FIELD);
        ContainerRepositoryRequest creationDetails = new ContainerRepositoryRequest(compartment, displayName);
        return new CreateContainerRepositoryCommand().create(creationDetails);
    }

    @Override
    public CompletableFuture<Map<String, Object>> steps() {
        HashMap result = new HashMap();
        CompletableFuture<Map<String, Object>> future = new CompletableFuture<Map<String, Object>>();
        String suggestedName = this.getSuggestedName(future);
        NotifyDescriptor.InputLine ci = new NotifyDescriptor.InputLine(Bundle.EnterName(), Bundle.EnterName());
        if (suggestedName != null) {
            ci.setInputText(suggestedName);
        }
        DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)ci).handle((r, exception) -> {
            result.put(REPOSITORY_NAME_FIELD, r.getInputText());
            if (exception != null) {
                future.completeExceptionally((Throwable)exception);
            } else {
                future.complete(result);
            }
            return null;
        });
        return future;
    }

    private String getSuggestedName(CompletableFuture future) {
        CompletableFuture<Project[]> projects = OpenProjectsFinder.getDefault().findTopLevelProjects();
        ProjectInformation pi = null;
        try {
            Project[] p = projects.get();
            if (p != null && p.length > 0) {
                pi = ProjectUtils.getInformation((Project)p[0]);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            future.completeExceptionally(ex);
        }
        return pi == null ? null : pi.getDisplayName();
    }
}

