/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.ErrorManager;
import org.w3c.dom.Node;

public abstract class SyntaxElement
implements org.netbeans.modules.xml.text.api.dom.SyntaxElement {
    protected XMLSyntaxSupport support;
    private WeakReference<TokenItem> first;
    private WeakReference<SyntaxElement> previous;
    private WeakReference<SyntaxElement> next;
    protected int offset;
    protected int length;

    public SyntaxElement(XMLSyntaxSupport support, TokenItem first, int to) {
        this.support = support;
        this.offset = first.getOffset();
        this.length = to - this.offset;
        this.first = new WeakReference<TokenItem>(first);
    }

    protected TokenItem first() {
        TokenItem cached_first = (TokenItem)this.first.get();
        if (cached_first == null) {
            try {
                TokenItem new_first = this.support.getTokenChain(this.offset, this.offset + 1);
                this.first = new WeakReference<TokenItem>(new_first);
                return new_first;
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        return cached_first;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    void setNext(SyntaxElement se) {
        this.next = new WeakReference<SyntaxElement>(se);
    }

    void setPrevious(SyntaxElement se) {
        this.previous = new WeakReference<SyntaxElement>(se);
    }

    public SyntaxElement getPrevious() {
        try {
            SyntaxElement cached_previous;
            SyntaxElement syntaxElement = cached_previous = this.previous == null ? null : (SyntaxElement)this.previous.get();
            if (cached_previous == null) {
                if (this.offset == 0) {
                    return null;
                }
                SyntaxElement new_previous = this.support.getElementChain(this.getElementOffset() - 1);
                if (new_previous != null) {
                    this.setPrevious(new_previous);
                    new_previous.setNext(this);
                    if (new_previous.offset == this.offset) {
                        IllegalStateException ex = new IllegalStateException("Previous cannot be the same as current element at offset " + this.offset);
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                        return null;
                    }
                }
                return new_previous;
            }
            return cached_previous;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public SyntaxElement getNext() {
        try {
            SyntaxElement cached_next;
            SyntaxElement syntaxElement = cached_next = this.next == null ? null : (SyntaxElement)this.next.get();
            if (cached_next == null) {
                SyntaxElement new_next = this.support.getElementChain(this.offset + this.length + 1);
                if (new_next != null) {
                    this.setNext(new_next);
                    new_next.setPrevious(this);
                    if (new_next.offset == this.offset) {
                        return null;
                    }
                }
                return new_next;
            }
            return cached_next;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public String toString() {
        String content = "?";
        try {
            content = this.support.getDocument().getText(this.offset, this.length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "SyntaxElement [offset=" + this.offset + "; length=" + this.length + " ;type = " + this.getClass().getName() + "; content:" + content + "]";
    }

    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.length;
    }

    public boolean equals(Object obj) {
        return obj instanceof SyntaxElement && ((SyntaxElement)obj).offset == this.offset;
    }

    public static class Error
    extends SyntaxElement {
        public Error(XMLSyntaxSupport support, TokenItem from, int to) {
            super(support, from, to);
        }

        @Override
        public String toString() {
            return "Error" + super.toString();
        }

        public int getType() {
            return -1;
        }

        public Node getNode() {
            return null;
        }

        public SyntaxElement getParentElement() {
            SyntaxElement x;
            for (x = this; x != null && x.getType() != 1; x = ((SyntaxElement)x).getPrevious()) {
            }
            return x;
        }
    }
}

