/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.TablesClause;

public class SQLStatement {
    SQLStatementKind kind;
    int startOffset;
    int endOffset;
    SortedMap<Integer, Context> offset2Context;
    TablesClause tablesClause;
    private List<SelectStatement> subqueries;

    SQLStatement(int startOffset, int endOffset, SortedMap<Integer, Context> offset2Context) {
        this(startOffset, endOffset, offset2Context, null, null);
    }

    SQLStatement(int startOffset, int endOffset, SortedMap<Integer, Context> offset2Context, TablesClause tablesClause) {
        this(startOffset, endOffset, offset2Context, tablesClause, null);
    }

    SQLStatement(int startOffset, int endOffset, SortedMap<Integer, Context> offset2Context, TablesClause tablesClause, List<SelectStatement> subqueries) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.offset2Context = offset2Context;
        this.tablesClause = tablesClause;
        this.subqueries = subqueries;
    }

    public SQLStatementKind getKind() {
        return this.kind;
    }

    public Context getContextAtOffset(int offset) {
        if (offset < this.startOffset || offset > this.endOffset) {
            return null;
        }
        Context result = null;
        if (this.subqueries != null) {
            for (SQLStatement sQLStatement : this.subqueries) {
                result = sQLStatement.getContextAtOffset(offset);
                if (result == null) continue;
                return result;
            }
        }
        for (Map.Entry entry : this.offset2Context.entrySet()) {
            if (offset >= (Integer)entry.getKey()) {
                result = (Context)((Object)entry.getValue());
                continue;
            }
            return result;
        }
        return result;
    }

    public List<SelectStatement> getSubqueries() {
        return this.subqueries;
    }

    TablesClause getTablesClause() {
        return this.tablesClause;
    }

    public static enum Context {
        START(0),
        DELETE(200),
        DROP(300),
        DROP_TABLE(310),
        INSERT(400),
        INSERT_INTO(410),
        COLUMNS(420),
        VALUES(430),
        SELECT(500),
        FROM(510),
        JOIN_CONDITION(520),
        WHERE(530),
        GROUP(540),
        GROUP_BY(550),
        HAVING(560),
        ORDER(570),
        ORDER_BY(580),
        UPDATE(600),
        SET(610),
        CREATE(700),
        CREATE_PROCEDURE(710),
        CREATE_FUNCTION(720),
        BEGIN(730),
        END(740),
        CREATE_TABLE(750),
        CREATE_TEMPORARY_TABLE(760),
        CREATE_DATABASE(770),
        CREATE_SCHEMA(780),
        CREATE_VIEW(790),
        CREATE_VIEW_AS(800);

        private final int order;

        private Context(int order) {
            this.order = order;
        }

        public boolean isAfter(Context context) {
            return this.order >= context.order;
        }
    }
}

