/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ForeignKeyColumnNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ForeignKeyColumnNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<ForeignKey> handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private static final Comparator<Node> foreignKeyColumnComparator = new Comparator<Node>(){

        @Override
        public int compare(Node node1, Node node2) {
            ForeignKeyColumnNode n1 = (ForeignKeyColumnNode)node1;
            ForeignKeyColumnNode n2 = (ForeignKeyColumnNode)node2;
            int result = 1;
            if (n1.getPosition() < n2.getPosition()) {
                result = -1;
            }
            return result;
        }
    };

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ForeignKeyColumnNodeProvider(Lookup lookup) {
        super(lookup, foreignKeyColumnComparator);
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){
                    final /* synthetic */ ForeignKeyColumnNodeProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(Metadata metaData) {
                        ForeignKey key = (ForeignKey)this.this$0.handle.resolve(metaData);
                        if (key != null) {
                            Collection columns = key.getColumns();
                            for (ForeignKeyColumn column : columns) {
                                MetadataElementHandle h = MetadataElementHandle.create((MetadataElement)column);
                                Collection matches = this.this$0.getNodes(h);
                                if (matches.size() > 0) {
                                    newList.addAll(matches);
                                    continue;
                                }
                                NodeDataLookup lookup = new NodeDataLookup();
                                lookup.add(this.this$0.connection);
                                lookup.add(h);
                                newList.add(ForeignKeyColumnNode.create(lookup, this.this$0));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ForeignKeyColumnNodeProvider createInstance(Lookup lookup) {
                ForeignKeyColumnNodeProvider provider = new ForeignKeyColumnNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

