/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.actions.DocumentsAction;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JTextAreaOperator;
import org.netbeans.jemmy.operators.Operator;

public class DocumentsDialogOperator
extends NbDialogOperator {
    private JButtonOperator _btClose;
    private JButtonOperator _btActivate;
    private JButtonOperator _btCloseDocuments;
    private JButtonOperator _btSaveDocuments;
    private JTextAreaOperator _txtDescription;
    private JListOperator _lstDocuments;
    private static final String title = Bundle.getString((String)"org.netbeans.core.windows.view.ui.Bundle", (String)"CTL_DocumentsTitle");

    public DocumentsDialogOperator() {
        super(title);
    }

    public static DocumentsDialogOperator invoke() {
        new DocumentsAction().perform();
        return new DocumentsDialogOperator();
    }

    public JButtonOperator btSwitchToDocument() {
        if (this._btActivate == null) {
            String switchCaption = Bundle.getStringTrimmed((String)"org.netbeans.core.windows.view.ui.Bundle", (String)"LBL_Activate");
            this._btActivate = new JButtonOperator((ContainerOperator)this, switchCaption);
        }
        return this._btActivate;
    }

    public JButtonOperator btCloseDocuments() {
        if (this._btCloseDocuments == null) {
            String closeDocumentsCaption = Bundle.getStringTrimmed((String)"org.netbeans.core.windows.view.ui.Bundle", (String)"LBL_CloseDocuments");
            this._btCloseDocuments = new JButtonOperator((ContainerOperator)this, closeDocumentsCaption);
        }
        return this._btCloseDocuments;
    }

    public JButtonOperator btSaveDocuments() {
        if (this._btSaveDocuments == null) {
            String saveDocumentsCaption = Bundle.getStringTrimmed((String)"org.netbeans.core.windows.view.ui.Bundle", (String)"LBL_SaveDocuments");
            this._btSaveDocuments = new JButtonOperator((ContainerOperator)this, saveDocumentsCaption);
        }
        return this._btSaveDocuments;
    }

    public JButtonOperator btClose() {
        if (this._btClose == null) {
            String closeCaption = Bundle.getStringTrimmed((String)"org.netbeans.core.windows.services.Bundle", (String)"CLOSED_OPTION_CAPTION");
            Operator.StringComparator oldComparator = this.getComparator();
            this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
            this._btClose = new JButtonOperator((ContainerOperator)this, closeCaption);
            this.setComparator(oldComparator);
        }
        return this._btClose;
    }

    public JTextAreaOperator txtDescription() {
        if (this._txtDescription == null) {
            this._txtDescription = new JTextAreaOperator((ContainerOperator)this);
        }
        return this._txtDescription;
    }

    public JListOperator lstDocuments() {
        if (this._lstDocuments == null) {
            this._lstDocuments = new JListOperator((ContainerOperator)this);
        }
        return this._lstDocuments;
    }

    public void switchToDocument() {
        this.btSwitchToDocument().push();
    }

    public void closeDocuments() {
        this.btCloseDocuments().push();
    }

    public void saveDocuments() {
        this.btSaveDocuments().push();
    }

    public String getDescription() {
        return this.txtDescription().getText();
    }

    public void selectDocument(String name) {
        this.lstDocuments().selectItem(name);
    }

    public void selectDocument(int index) {
        this.lstDocuments().selectItem(index);
    }

    public void selectDocuments(String[] names) {
        this.lstDocuments().selectItem(names);
    }

    public void selectDocuments(int[] indexes) {
        this.lstDocuments().selectItems(indexes);
    }

    public void verify() {
        this.btSwitchToDocument();
        this.btCloseDocuments();
        this.btSaveDocuments();
        this.btClose();
        this.txtDescription();
        this.lstDocuments();
    }
}

