/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.data.PayaraContainer;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersion;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.utils.Jar;
import org.netbeans.modules.payara.tooling.utils.JavaUtils;
import org.netbeans.modules.payara.tooling.utils.NetUtils;
import org.netbeans.modules.payara.tooling.utils.OsUtils;

public class ServerUtils {
    private static final Logger LOGGER = new Logger(ServerUtils.class);
    public static final String AS_JAVA_ENV = "AS_JAVA";
    public static final String PF_JAVA_ROOT_PROPERTY = "com.sun.aas.javaRoot";
    public static final String PF_HOME_PROPERTY = "com.sun.aas.installRoot";
    public static final String PF_DOMAIN_ROOT_PROPERTY = "com.sun.aas.instanceRoot";
    public static final PayaraFilter PF_HOME_DIR_FILTER = new PayaraFilter();
    public static final String PF_DOMAINS_DIR_NAME = "domains";
    public static final String PF_DOMAIN_CONFIG_DIR_NAME = "config";
    public static final String PF_DOMAIN_CONFIG_FILE_NAME = "domain.xml";
    public static final String PF_MODULES_DIR_NAME = "modules";
    public static final String PF_H2_DIR_NAME = "h2db";
    public static final String PF_LIB_DIR_NAME = "lib";
    public static final String PF_EMBEDDED_DIR_NAME = "embedded";
    public static String PF_LOG_DIR_NAME = "logs";
    public static String PF_LOG_FILE_NAME = "server.log";
    public static final String VERSION_MATCHER = "(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String GF_JAR_MATCHER = "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String PF_COMMON_UTIL_JAR = "common-util.jar";
    public static final String PF_JERSEY_2_COMMON_JAR = "jersey-common.jar";
    public static final String PF_JERSEY_1_CORE_JAR = "jersey-core.jar";
    public static final String PF_EMBEDDED_STATIC_SHELL_JAR = "glassfish-embedded-static-shell.jar";
    public static final String PF_VERIFIER_JAR = "verifier.jar";
    public static final String PF_JAVAHELP_JAR = "javahelp.jar";
    private static String VERSION_CLASS = "com.sun.appserv.server.util.Version";
    public static String VERIFIER_MAIN_CLASS = "com.sun.enterprise.tools.verifier.VerifierMain";
    private static String FULL_VERSION_PATTERN = "[0-9]+(\\.[0-9]+){1,3}";
    private static String FULL_VERSION_METHOD = "getFullVersion";
    private static String AUTH_BASIC_FIELD_SEPARATPR = ":";
    public static String PF_DOMAIN_ARG = "--domain";
    public static String PF_DOMAIN_DIR_ARG = "--domaindir";
    public static final String PF_SERVICE_NOT_YET_READY_MSG = "V3 cannot process this command at this time, please wait";
    public static final String MANIFEST_EOL = "%%%EOL%%%";
    public static final String MANIFEST_RESOURCES_SEPARATOR = "[,;]";
    public static final String MANIFEST_COMPONENTS_SEPARATOR = ";";
    private static final String MANIFEST_COMPONENT_FULL_REGEX = " *([^ ]+) +< *([^ ,]+) *((?:, *[^ ,]+ *)*)> *";
    private static final String MANIFEST_COMPONENT_COMP_REGEX = ", *([^ ,]+) *";
    private static final Pattern MANIFEST_COMPONENT_FULL_PATTERN = Pattern.compile(" *([^ ]+) +< *([^ ,]+) *((?:, *[^ ,]+ *)*)> *", 2);
    private static final Pattern MANIFEST_COMPONENT_COMP_PATTERN = Pattern.compile(", *([^ ,]+) *", 2);

    public static File getJarName(String serverHome, String pattern) {
        return ServerUtils.getJarName(serverHome, pattern, PF_MODULES_DIR_NAME);
    }

    public static File getJarName(String serverHome, String pattern, String dir) {
        File dirFile = new File(serverHome + File.separatorChar + dir);
        return ServerUtils.getFileFromPattern(pattern, dirFile);
    }

    public static File getFileFromPattern(String pattern, File dir) {
        assert (pattern != null) : "Search pattern should not be null";
        assert (dir != null) : "Search directory tree root should not be null";
        int subindex = pattern.lastIndexOf("/");
        if (subindex != -1) {
            String subdir = pattern.substring(0, subindex);
            pattern = pattern.substring(subindex + 1);
            dir = new File(dir, subdir);
        }
        if (dir.canRead() && dir.isDirectory()) {
            String expressPattern = pattern.replace(VERSION_MATCHER, ".jar");
            File candidate = new File(dir, expressPattern);
            if (!"".equals(expressPattern) && candidate.exists()) {
                return candidate;
            }
            File[] candidates = dir.listFiles(new VersionFilter(pattern));
            if (candidates != null && candidates.length > 0) {
                return candidates[0];
            }
        }
        return null;
    }

    public static void addPathElement(StringBuilder rootPath, String next) {
        int rootPathLength = rootPath.length();
        if (rootPathLength > 0 && rootPath.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != rootPathLength) {
            rootPath.append(File.separator);
        }
        rootPath.append(next);
    }

    public static File getCommonUtilJarInModules(String serverHome) {
        StringBuilder commonUtilJarPath = new StringBuilder(serverHome.length() + PF_MODULES_DIR_NAME.length() + PF_COMMON_UTIL_JAR.length() + 2 * OsUtils.FILE_SEPARATOR_LENGTH);
        commonUtilJarPath.append(serverHome);
        ServerUtils.addPathElement(commonUtilJarPath, PF_MODULES_DIR_NAME);
        ServerUtils.addPathElement(commonUtilJarPath, PF_COMMON_UTIL_JAR);
        return new File(commonUtilJarPath.toString());
    }

    public static File getJarInModules(String serverHome, String jarName) {
        StringBuilder commonUtilJarPath = new StringBuilder(serverHome.length() + PF_MODULES_DIR_NAME.length() + jarName.length() + 2 * OsUtils.FILE_SEPARATOR_LENGTH);
        commonUtilJarPath.append(serverHome);
        ServerUtils.addPathElement(commonUtilJarPath, PF_MODULES_DIR_NAME);
        ServerUtils.addPathElement(commonUtilJarPath, jarName);
        return new File(commonUtilJarPath.toString());
    }

    public static File getJerseyCommonJarInModules(String serverHome) {
        File jerseyCommon = ServerUtils.getJarInModules(serverHome, PF_JERSEY_2_COMMON_JAR);
        if (jerseyCommon.isFile() && jerseyCommon.canRead()) {
            return jerseyCommon;
        }
        jerseyCommon = ServerUtils.getJarInModules(serverHome, PF_JERSEY_1_CORE_JAR);
        if (jerseyCommon.isFile() && jerseyCommon.canRead()) {
            return jerseyCommon;
        }
        return null;
    }

    public static String getVerifierJar(String serverHome) {
        assert (serverHome != null) : "Payara server home directory should not be null";
        boolean appendSeparator = serverHome.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != serverHome.length();
        StringBuilder sb = new StringBuilder(serverHome.length() + (appendSeparator ? 2 * OsUtils.FILE_SEPARATOR_LENGTH : 1 * OsUtils.FILE_SEPARATOR_LENGTH) + PF_MODULES_DIR_NAME.length() + PF_VERIFIER_JAR.length());
        sb.append(serverHome);
        if (appendSeparator) {
            sb.append(File.separator);
        }
        sb.append(PF_MODULES_DIR_NAME);
        sb.append(File.separator);
        sb.append(PF_VERIFIER_JAR);
        return sb.toString();
    }

    public static String getJavaHelpJar(String serverHome) {
        assert (serverHome != null) : "Payara server home directory should not be null";
        boolean appendSeparator = serverHome.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != serverHome.length();
        StringBuilder sb = new StringBuilder(serverHome.length() + (appendSeparator ? 2 * OsUtils.FILE_SEPARATOR_LENGTH : 1 * OsUtils.FILE_SEPARATOR_LENGTH) + PF_LIB_DIR_NAME.length() + PF_JAVAHELP_JAR.length());
        sb.append(serverHome);
        if (appendSeparator) {
            sb.append(File.separator);
        }
        sb.append(PF_LIB_DIR_NAME);
        sb.append(File.separator);
        sb.append(PF_JAVAHELP_JAR);
        return sb.toString();
    }

    public static String getEmbeddedStaticShellJar(String serverHome) {
        assert (serverHome != null) : "Payara server home directory should not be null";
        boolean appendSeparator = serverHome.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != serverHome.length();
        StringBuilder sb = new StringBuilder(serverHome.length() + (appendSeparator ? 3 * OsUtils.FILE_SEPARATOR_LENGTH : 2 * OsUtils.FILE_SEPARATOR_LENGTH) + PF_LIB_DIR_NAME.length() + PF_EMBEDDED_DIR_NAME.length() + PF_EMBEDDED_STATIC_SHELL_JAR.length());
        sb.append(serverHome);
        if (appendSeparator) {
            sb.append(File.separator);
        }
        sb.append(PF_LIB_DIR_NAME);
        sb.append(File.separator);
        sb.append(PF_EMBEDDED_DIR_NAME);
        sb.append(File.separator);
        sb.append(PF_EMBEDDED_STATIC_SHELL_JAR);
        return sb.toString();
    }

    public static String getJerseyVersion(String serverHome) {
        File jerseyFile = ServerUtils.getJerseyCommonJarInModules(serverHome);
        if (jerseyFile != null) {
            Jar jerseyJar = new Jar(jerseyFile);
            String version = jerseyJar.getBundleVersion();
            jerseyJar.close();
            return version;
        }
        return null;
    }

    public static String getVersionString(String fullVersionString) {
        Pattern p;
        Matcher m;
        if (fullVersionString != null && (m = (p = Pattern.compile(FULL_VERSION_PATTERN)).matcher(fullVersionString)).find()) {
            return fullVersionString.substring(m.start(), m.end());
        }
        return null;
    }

    @Deprecated
    public static PayaraVersion getServerVersion(String serverHome) {
        PayaraVersion version;
        block10: {
            version = null;
            File commonUtilJar = ServerUtils.getCommonUtilJarInModules(serverHome);
            if (commonUtilJar.canRead()) {
                try {
                    String versionString;
                    URLClassLoader cl = new URLClassLoader(new URL[]{commonUtilJar.toURI().toURL()});
                    Class<?> c = cl.loadClass(VERSION_CLASS);
                    try {
                        Method mGetFullVersion = c.getMethod(FULL_VERSION_METHOD, new Class[0]);
                        System.getProperties().put(PF_HOME_PROPERTY, serverHome);
                        String fullVersionString = (String)mGetFullVersion.invoke(c, new Object[0]);
                        System.getProperties().remove(PF_HOME_PROPERTY);
                        versionString = ServerUtils.getVersionString(fullVersionString);
                        if (versionString != null) {
                            version = PayaraVersion.toValue(versionString);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + ": ", ex);
                    }
                    if (version != null) break block10;
                    try {
                        JarFile jar = new JarFile(commonUtilJar);
                        Manifest manifest = jar.getManifest();
                        versionString = ServerUtils.getVersionString(manifest.getMainAttributes().getValue(BUNDLE_VERSION));
                        if (versionString != null) {
                            version = PayaraVersion.toValue(versionString);
                        }
                    }
                    catch (IOException ioe) {
                        Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + ": ", ioe);
                    }
                }
                catch (ClassNotFoundException | MalformedURLException ex) {
                    Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + ": ", ex);
                }
            } else {
                Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + " is not readable: Exists: " + commonUtilJar.exists() + " Can read: " + commonUtilJar.canRead(), (Throwable)null);
            }
        }
        return version;
    }

    public static PayaraPlatformVersionAPI getPlatformVersion(String serverHome) {
        PayaraPlatformVersionAPI version;
        block10: {
            version = null;
            File commonUtilJar = ServerUtils.getCommonUtilJarInModules(serverHome);
            if (commonUtilJar.canRead()) {
                try {
                    String versionString;
                    URLClassLoader cl = new URLClassLoader(new URL[]{commonUtilJar.toURI().toURL()});
                    Class<?> c = cl.loadClass(VERSION_CLASS);
                    try {
                        Method mGetFullVersion = c.getMethod(FULL_VERSION_METHOD, new Class[0]);
                        System.getProperties().put(PF_HOME_PROPERTY, serverHome);
                        String fullVersionString = (String)mGetFullVersion.invoke(c, new Object[0]);
                        System.getProperties().remove(PF_HOME_PROPERTY);
                        versionString = ServerUtils.getVersionString(fullVersionString);
                        if (versionString != null) {
                            version = PayaraPlatformVersion.toValue(versionString);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + ": ", ex);
                    }
                    if (version != null) break block10;
                    try {
                        JarFile jar = new JarFile(commonUtilJar);
                        Manifest manifest = jar.getManifest();
                        versionString = ServerUtils.getVersionString(manifest.getMainAttributes().getValue(BUNDLE_VERSION));
                        if (versionString != null) {
                            version = PayaraPlatformVersion.toValue(versionString);
                        }
                    }
                    catch (IOException ioe) {
                        Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + ": ", ioe);
                    }
                }
                catch (ClassNotFoundException | MalformedURLException ex) {
                    Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + ": ", ex);
                }
            } else {
                Logger.log(Level.WARNING, "Cannot retrieve Payara version: " + commonUtilJar.getAbsolutePath() + " is not readable: Exists: " + commonUtilJar.exists() + " Can read: " + commonUtilJar.canRead(), (Throwable)null);
            }
        }
        return version;
    }

    public static String manifestDecode(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll(MANIFEST_EOL, "\n");
    }

    public static String basicAuthCredentials(String user, String password) {
        StringBuilder sb = new StringBuilder(user.length() + AUTH_BASIC_FIELD_SEPARATPR.length() + password.length());
        sb.append(user);
        sb.append(AUTH_BASIC_FIELD_SEPARATPR);
        sb.append(password);
        return DatatypeConverter.printBase64Binary((byte[])sb.toString().getBytes());
    }

    public static boolean isHttpPortListening(PayaraServer server) {
        return server.isRemote() ? NetUtils.isPortListeningRemote(server.getHost(), server.getPort()) : NetUtils.isPortListeningLocal(server.getHost(), server.getPort());
    }

    public static boolean isHttpPortListening(PayaraServer server, int timeout) {
        return server.isRemote() ? NetUtils.isPortListeningRemote(server.getHost(), server.getPort(), timeout) : NetUtils.isPortListeningLocal(server.getHost(), server.getPort());
    }

    public static boolean isAdminPortListening(PayaraServer server) {
        return server.isRemote() ? NetUtils.isPortListeningRemote(server.getHost(), server.getAdminPort()) : NetUtils.isPortListeningLocal(server.getHost(), server.getAdminPort());
    }

    public static boolean isAdminPortListening(PayaraServer server, int timeout) {
        return server.isRemote() ? NetUtils.isPortListeningRemote(server.getHost(), server.getAdminPort(), timeout) : NetUtils.isPortListeningLocal(server.getHost(), server.getAdminPort());
    }

    public static String cmdLineArgument(String name, String value) {
        StringBuilder sb = new StringBuilder(name.length() + " ".length() + value.length());
        sb.append(name);
        sb.append(" ");
        sb.append(value);
        return sb.toString();
    }

    public static void addComponentToMap(Map<String, List<String>> map, String component) {
        List<String> componentList;
        String componentName;
        Logger.log(Level.FINER, "Processing component \"{0}\"", new Object[]{component});
        Matcher fullMatecher = MANIFEST_COMPONENT_FULL_PATTERN.matcher(component);
        if (fullMatecher.matches()) {
            String containerName;
            componentName = fullMatecher.group(1);
            PayaraContainer container = PayaraContainer.toValue(fullMatecher.group(2));
            String moreContainers = fullMatecher.group(3);
            if (moreContainers != null && moreContainers.length() > 0) {
                Matcher compMatcher = MANIFEST_COMPONENT_COMP_PATTERN.matcher(moreContainers);
                while (compMatcher.find()) {
                    PayaraContainer nextContainer = PayaraContainer.toValue(compMatcher.group(1));
                    if (nextContainer != null && container != null && nextContainer.ordinal() < container.ordinal()) {
                        container = nextContainer;
                        continue;
                    }
                    if (nextContainer != null) continue;
                    Logger.log(Level.WARNING, "Error processing component \"{0}\"", new Object[]{component});
                }
            }
            if ((componentList = map.get(containerName = container != null ? container.toString() : "null")) == null) {
                componentList = new ArrayList<String>();
                map.put(containerName, componentList);
            }
        } else {
            throw new CommandException("Invalid component item");
        }
        componentList.add(componentName);
    }

    public static String serverLogFileRelativePath() {
        StringBuilder sb = new StringBuilder(PF_LOG_DIR_NAME.length() + File.separator.length() + PF_LOG_FILE_NAME.length());
        sb.append(PF_LOG_DIR_NAME);
        sb.append(File.separator);
        sb.append(PF_LOG_FILE_NAME);
        return sb.toString();
    }

    public static String getDomainPath(PayaraServer server) {
        String domainName = server.getDomainName();
        String domainsFolder = server.getDomainsFolder();
        if (domainsFolder == null) {
            return null;
        }
        boolean appendSeparator = domainsFolder.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != domainsFolder.length();
        StringBuilder sb = new StringBuilder(domainsFolder.length() + (appendSeparator ? OsUtils.FILE_SEPARATOR_LENGTH : 0) + domainName.length());
        sb.append(domainsFolder);
        if (appendSeparator) {
            sb.append(File.separator);
        }
        sb.append(domainName);
        return sb.toString();
    }

    public static String getDomainConfigPath(String domainDir) {
        if (domainDir == null) {
            return PF_DOMAIN_CONFIG_DIR_NAME;
        }
        boolean appendSeparator = domainDir.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != domainDir.length();
        StringBuilder sb = new StringBuilder(domainDir.length() + (appendSeparator ? OsUtils.FILE_SEPARATOR_LENGTH : 0) + PF_DOMAIN_CONFIG_DIR_NAME.length());
        sb.append(domainDir);
        if (appendSeparator) {
            sb.append(File.separator);
        }
        sb.append(PF_DOMAIN_CONFIG_DIR_NAME);
        return sb.toString();
    }

    public static String getDomainConfigFile(String domainsRoot, String domainName) {
        String METHOD = "getDomainConfigFile";
        if (domainsRoot == null) {
            throw new IllegalArgumentException(LOGGER.excMsg("getDomainConfigFile", "domainsRootNull"));
        }
        if (domainName == null) {
            throw new IllegalArgumentException(LOGGER.excMsg("getDomainConfigFile", "domainNameNull"));
        }
        StringBuilder sb = new StringBuilder(domainsRoot.length() + domainName.length() + PF_DOMAIN_CONFIG_DIR_NAME.length() + PF_DOMAIN_CONFIG_FILE_NAME.length() + 3 * OsUtils.FILE_SEPARATOR_LENGTH);
        sb.append(domainsRoot).append(File.separator);
        sb.append(domainName).append(File.separator);
        sb.append(PF_DOMAIN_CONFIG_DIR_NAME).append(File.separator);
        sb.append(PF_DOMAIN_CONFIG_FILE_NAME);
        return sb.toString();
    }

    public static File getServerLogFile(PayaraServer server) {
        return new File(ServerUtils.getDomainPath(server), ServerUtils.serverLogFileRelativePath());
    }

    public static String getH2Root(PayaraServer server) {
        String serverRoot = server.getServerRoot();
        if (serverRoot == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(serverRoot.length() + File.separator.length() + PF_H2_DIR_NAME.length());
        sb.append(serverRoot);
        sb.append(File.separator);
        sb.append(PF_H2_DIR_NAME);
        return sb.toString();
    }

    public static String javaRootProperty(String javaHome) {
        return JavaUtils.systemProperty(PF_JAVA_ROOT_PROPERTY, javaHome);
    }

    public static boolean notYetReadyMsg(String msg) {
        if (msg == null) {
            return false;
        }
        return msg.startsWith(PF_SERVICE_NOT_YET_READY_MSG);
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String namePattern) {
            this.pattern = Pattern.compile(namePattern);
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }

    public static class PayaraFilter
    implements FileFilter {
        @Override
        public boolean accept(File path) {
            if (path.isDirectory() && path.canRead()) {
                File commonUtilJar = ServerUtils.getCommonUtilJarInModules(path.getAbsolutePath());
                return commonUtilJar.isFile() && commonUtilJar.canRead();
            }
            return false;
        }
    }
}

