/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.reload;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.reload.Bundle;
import org.netbeans.modules.project.dependency.reload.Forwarder;
import org.netbeans.modules.project.dependency.reload.ReloadApiAccessor;
import org.netbeans.modules.project.dependency.reload.ReloadSpiAccessor;
import org.netbeans.modules.project.dependency.reload.Reloader;
import org.netbeans.modules.project.dependency.reload.StateDataListener;
import org.netbeans.modules.project.dependency.reload.WeakIdentityMap;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class ProjectReloadInternal {
    public static final Logger LOG = Logger.getLogger(ProjectReloadInternal.class.getName());
    private static final int DEFAULT_PROJECT_RELOAD_CONCURRENCY = 10;
    private static final int PROJECT_RELOAD_CONCURRENCY = Integer.getInteger(ProjectReloadInternal.class.getName() + ".reload.concurrency", 10);
    static final int STATE_TIMEOUT_MS = 5000;
    private static ProjectReloadInternal INSTANCE;
    public static final RequestProcessor RELOAD_RP;
    public static final RequestProcessor NOTIFIER;
    static final RequestProcessor STATE_CLEANER;
    private static final Map<Collection, StateRef> STATE_CACHE;
    private final Map<Project, ProjectOperations> pendingOperations = new WeakHashMap<Project, ProjectOperations>();
    private final Set<ProjectOperations> terminatingOperations = new HashSet<ProjectOperations>();
    private final WeakIdentityMap<ProjectReloadImplementation.ProjectStateData, IdentityHolder> stateIdentity = WeakIdentityMap.newHashMap();
    public static final StateParts EMPTY_PARTS;
    private final RequestProcessor dispatcher = new RequestProcessor(String.valueOf(ProjectReloadInternal.class) + " Scheduler");
    private final BlockingQueue<RequestProcessor> loaderProcessors = new ArrayBlockingQueue<RequestProcessor>(PROJECT_RELOAD_CONCURRENCY);

    public static synchronized ProjectReloadInternal getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProjectReloadInternal();
        }
        return INSTANCE;
    }

    Lookup.Result<? extends ProjectReloadImplementation<Object>> findImplementations(Project p) {
        return p.getLookup().lookupResult(ProjectReloadImplementation.class);
    }

    static Collection variantKey(Project p, StateParts parts, Lookup context) {
        HashList c = new HashList();
        c.add(p);
        if (parts == null) {
            return c;
        }
        for (Map.Entry en : parts.entrySet()) {
            Object k;
            ProjectReloadImplementation.ProjectStateData d = (ProjectReloadImplementation.ProjectStateData)en.getValue();
            if (context == null || context == Lookup.EMPTY || (k = en.getKey() instanceof ProjectReloadImplementation.ExtendedQuery ? ((ProjectReloadImplementation.ExtendedQuery)en.getKey()).createVariant(context) : null) == null) continue;
            c.add(en.getKey());
            c.add(k);
        }
        return c;
    }

    ProjectReload.ProjectState doCreateState(Project p, StateParts parts, ProjectReload.StateRequest req) {
        ProjectReload.Quality status = null;
        boolean consistent = true;
        LinkedHashSet<FileObject> edited = new LinkedHashSet<FileObject>();
        LinkedHashSet<FileObject> modified = new LinkedHashSet<FileObject>();
        LinkedHashSet<FileObject> loadedFiles = new LinkedHashSet<FileObject>();
        long timestamp = Long.MAX_VALUE;
        boolean valid = true;
        ArrayList<Object> ids = new ArrayList<Object>();
        for (Map.Entry en : parts.entrySet()) {
            long time;
            Collection<FileObject> mods;
            ProjectReloadImplementation.ProjectStateData data = (ProjectReloadImplementation.ProjectStateData)en.getValue();
            if (data == null) continue;
            ids.add(this.identity(p, (ProjectReloadImplementation)en.getKey(), data));
            ProjectReload.Quality q = data.getQuality();
            if (status == null || q.isWorseThan(status)) {
                status = q;
            }
            if ((mods = data.getFiles()) != null) {
                loadedFiles.addAll(mods);
            }
            if ((time = data.getTimestamp()) > 0L && time < timestamp) {
                timestamp = time;
            }
            if (!data.isValid() && LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "New state invalid because of {0}", data.toString());
            }
            valid &= data.isValid();
        }
        for (FileObject f : loadedFiles) {
            long t = f.lastModified().getTime();
            if (f.getLookup().lookup(SaveCookie.class) != null) {
                edited.add(f);
                LOG.log(Level.FINER, "New state inconsistent because of {0} is edited", f);
                consistent = false;
                break;
            }
            if (timestamp <= 0L || t <= timestamp) continue;
            LOG.log(Level.FINER, "New state inconsistent because of {0} is newer: file time: {1}, timestamp: {2}", new Object[]{f, t, timestamp});
            consistent = false;
            modified.add(f);
        }
        if (parts.isEmpty()) {
            status = ProjectReload.Quality.NONE;
            timestamp = -1L;
        }
        ProjectReload.Quality tq = req == null ? status : req.getTargetQuality();
        ProjectReload.ProjectState ps = ReloadApiAccessor.get().createState(p, timestamp, parts, status, tq, consistent, valid, loadedFiles, modified, edited, ids);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Created state {0} from {1}", new Object[]{ps.toString(), parts.toString()});
        }
        return ps;
    }

    boolean mergeStates(ProjectReload.ProjectState cached, ProjectReload.ProjectState now, StateParts parts, ProjectReload.StateRequest req) {
        if (cached.isValid() != now.isValid() || cached.isConsistent() != now.isConsistent() || cached.getTimestamp() != now.getTimestamp()) {
            return false;
        }
        if (cached.getQuality().isWorseThan(now.getQuality())) {
            return false;
        }
        StateParts cachedParts = ReloadApiAccessor.get().getParts(cached);
        if (cachedParts.size() != parts.size()) {
            return false;
        }
        for (ProjectReloadImplementation impl : parts.keySet()) {
            ProjectReloadImplementation.ProjectStateData cData = (ProjectReloadImplementation.ProjectStateData)cachedParts.get(impl);
            ProjectReloadImplementation.ProjectStateData nData = (ProjectReloadImplementation.ProjectStateData)parts.get(impl);
            if (!(impl instanceof ProjectReloadImplementation.ExtendedQuery ? !((ProjectReloadImplementation.ExtendedQuery)((Object)impl)).checkState(req, cData) : !Objects.equals(cData, nData))) continue;
            return false;
        }
        Forwarder fwd = Forwarder.create(cached, parts, now, true);
        return fwd != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<StateRef, ProjectReload.ProjectState> createState(ProjectReload.ProjectState previous, Project p, Collection variant, StateParts parts, boolean rejectInconsistent, ProjectReload.StateRequest req) {
        StateRef ref;
        ProjectReload.ProjectState state = this.doCreateState(p, parts, req);
        ProjectReload.ProjectState cur = null;
        HashSet<ProjectReload.ProjectState> obsolete = new HashSet<ProjectReload.ProjectState>();
        Map<Collection, StateRef> map = STATE_CACHE;
        synchronized (map) {
            StateDataListener l;
            StateRef oldRef = STATE_CACHE.get(variant);
            if (oldRef != null && (cur = (ProjectReload.ProjectState)oldRef.get()) != null) {
                if (this.mergeStates(cur, state, parts, req)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Project {0}: reused & merged state {1} in place of {2}", new Object[]{p, cur.toString(), state.toString()});
                    }
                    return Pair.of((Object)oldRef, (Object)cur);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Project {0}: obsolete state {1}", new Object[]{p, cur.toString()});
                }
                ReloadApiAccessor.get().chainPrevious(state, cur, obsolete);
            }
            ref = new StateRef(variant, state);
            ref.toDetach = l = new StateDataListener(p, parts, ref);
            if (!parts.isEmpty()) {
                l.init();
            }
            if (!state.isConsistent() && rejectInconsistent) {
                return Pair.of(null, (Object)state);
            }
            if (cur != previous && previous != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Project {0}: obsolete previous state {1}", new Object[]{p, previous.toString()});
                }
                ReloadApiAccessor.get().chainPrevious(state, previous, obsolete);
            }
            STATE_CACHE.put(variant, ref);
        }
        if (!obsolete.isEmpty() && LOG.isLoggable(Level.FINE) && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Project {0}: invalidate states", new Object[]{p, ((Object)obsolete).toString()});
        }
        obsolete.forEach(s -> ReloadApiAccessor.get().fireInvalid((ProjectReload.ProjectState)s));
        if (cur != null) {
            this.invalidatePreviousState(parts, cur);
        }
        if (previous != cur) {
            this.invalidatePreviousState(parts, previous);
        }
        return Pair.of((Object)ref, (Object)state);
    }

    private void invalidatePreviousState(StateParts parts, ProjectReload.ProjectState previous) {
        if (previous == null) {
            return;
        }
        StateParts oparts = ReloadApiAccessor.get().getParts(previous);
        for (ProjectReloadImplementation k : parts.keySet()) {
            ProjectReloadImplementation.ProjectStateData od;
            ProjectReloadImplementation.ProjectStateData nd = (ProjectReloadImplementation.ProjectStateData)parts.get(k);
            if (Objects.equals(nd, od = (ProjectReloadImplementation.ProjectStateData)oparts.get(k)) || od == null) continue;
            if (od.isValid() && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINER, "Invalidate project state {0}", od.toString());
            }
            od.fireChanged(true, false);
        }
        for (ProjectReloadImplementation k : oparts.keySet()) {
            ProjectReloadImplementation.ProjectStateData od;
            if (parts.get(k) != null || (od = (ProjectReloadImplementation.ProjectStateData)oparts.get(k)) == null) continue;
            if (od.isValid() && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINER, "Invalidate project state {0}", od.toString());
            }
            od.fireChanged(true, false);
        }
        ReloadApiAccessor.get().updateProjectState(previous, false, true, null, null, null);
    }

    public ProjectReload.ProjectState createNoneState(Project p) {
        StatePartsImpl parts = new StatePartsImpl();
        ProjectReload.ProjectState none = this.doCreateState(p, parts, null);
        return none;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Pair<StateRef, ProjectReload.ProjectState> getProjectState0(Project p, Lookup context, boolean nullIfUnknown) {
        ProjectReload.ProjectState oldS;
        StateRef ref;
        HashList variant;
        block15: {
            Pair<StateRef, ProjectReload.ProjectState> pair;
            Lookup.Result<? extends ProjectReloadImplementation<Object>> res = this.findImplementations(p);
            Collection col = res.allInstances();
            variant = new HashList();
            variant.add(p);
            for (ProjectReloadImplementation impl : col) {
                Object k = impl instanceof ProjectReloadImplementation.ExtendedQuery ? ((ProjectReloadImplementation.ExtendedQuery)((Object)impl)).createVariant(context) : null;
                if (k == null) continue;
                variant.add(impl);
                variant.add(k);
            }
            ref = null;
            oldS = null;
            this.lockOperation(p);
            try {
                Map<Collection, StateRef> map = STATE_CACHE;
                // MONITORENTER : map
                ref = STATE_CACHE.get(variant);
                if (ref != null) {
                    oldS = ref.touch();
                }
                if (oldS != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "STATE: project {0}: cached state returned: {1}", new Object[]{p, oldS.toString()});
                    }
                    Pair pair2 = Pair.of((Object)ref, (Object)oldS);
                    // MONITOREXIT : map
                    if (oldS != null && ref.toDetach != null) {
                        ref.toDetach.checkFileTimestamps();
                    }
                    this.endOperation(p, null, null);
                    return pair2;
                }
                if (!nullIfUnknown) break block15;
                pair = null;
            }
            catch (Throwable throwable) {
                if (oldS != null && ref.toDetach != null) {
                    ref.toDetach.checkFileTimestamps();
                }
                this.endOperation(p, null, null);
                throw throwable;
            }
            if (oldS != null && ref.toDetach != null) {
                ref.toDetach.checkFileTimestamps();
            }
            this.endOperation(p, null, null);
            return pair;
        }
        ProjectReload.ProjectState none = this.createNoneState(p);
        ref = new StateRef(variant, none);
        LOG.log(Level.FINE, "STATE: Project {0}: NONE state created: {1}", new Object[]{p, none});
        STATE_CACHE.put(variant, ref);
        Pair pair = Pair.of((Object)ref, (Object)none);
        // MONITOREXIT : map
        if (oldS != null && ref.toDetach != null) {
            ref.toDetach.checkFileTimestamps();
        }
        this.endOperation(p, null, null);
        return pair;
    }

    public static boolean checkConsistency(ProjectReload.ProjectState ps, StateParts parts, ProjectReload.StateRequest stateRequest) {
        boolean doReload;
        boolean bl = doReload = !ps.isValid() || stateRequest.isForceReload();
        if (stateRequest.isConsistent() && !ps.isConsistent()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINER, "{0}: CHECK: State inconsistent: {1}", new Object[]{stateRequest, ps.toString()});
            }
            doReload = true;
        }
        if (ps.getQuality().isWorseThan(stateRequest.getMinQuality())) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINER, "{0}: CHECK:State low quality: {1}", new Object[]{stateRequest, ps.toString()});
            }
            doReload = true;
        }
        if (!doReload) {
            for (ProjectReloadImplementation pi : parts.keySet()) {
                ProjectReloadImplementation.ProjectStateData psd = (ProjectReloadImplementation.ProjectStateData)parts.get(pi);
                if (!(pi instanceof ProjectReloadImplementation.ExtendedQuery) || ((ProjectReloadImplementation.ExtendedQuery)((Object)pi)).checkState(stateRequest, psd)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINER, "{0} CHECK: state data rejected: {0} / {1}", new Object[]{stateRequest, ps.toString(), psd.toString()});
                }
                return false;
            }
        }
        return doReload;
    }

    private static boolean satisfies(Project p, ProjectReload.StateRequest next, ProjectReload.StateRequest pending, ProjectReload.ProjectState state) {
        if (next.isForceReload()) {
            return false;
        }
        if (!next.isOfflineOperation() && pending.isOfflineOperation()) {
            return false;
        }
        if (next.isSaveModifications() && !pending.isSaveModifications()) {
            return false;
        }
        if (pending.getMinQuality().isWorseThan(next.getMinQuality())) {
            return false;
        }
        StateParts parts = state == null ? null : ReloadApiAccessor.get().getParts(state);
        for (ProjectReloadImplementation impl : p.getLookup().lookupAll(ProjectReloadImplementation.class)) {
            if (!(impl instanceof ProjectReloadImplementation.ExtendedQuery) || ((ProjectReloadImplementation.ExtendedQuery)((Object)impl)).satisfies(pending, next)) continue;
            LOG.log(Level.FINER, "CHECK: pending rejected: {0} / {1}", new Object[]{pending, next});
            return false;
        }
        return true;
    }

    public ProjectReloadInternal() {
        for (int i = 0; i < PROJECT_RELOAD_CONCURRENCY; ++i) {
            this.loaderProcessors.add(new RequestProcessor(this.getClass().getName() + "-1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ProjectReload.ProjectState> withProjectState2(StateRef refCurrent, Project p, ProjectReload.StateRequest stateRequest, Throwable origin) {
        Lookup.Result<? extends ProjectReloadImplementation<Object>> impls = this.findImplementations(p);
        if (impls.allItems().isEmpty()) {
            StatePartsImpl parts = new StatePartsImpl();
            Collection variant = ProjectReloadInternal.variantKey(p, null, stateRequest.getContext());
            Pair<StateRef, ProjectReload.ProjectState> s = this.createState(null, p, variant, parts, false, null);
            if (ProjectReload.Quality.NONE.isAtLeast(stateRequest.getMinQuality())) {
                return CompletableFuture.completedFuture((ProjectReload.ProjectState)s.second());
            }
            ProjectOperationException ex = new ProjectOperationException(p, ProjectOperationException.State.UNSUPPORTED, Bundle.TEXT_UnsupportedReload(ProjectUtils.getInformation((Project)p).getDisplayName()));
            return CompletableFuture.failedFuture(ex);
        }
        ProjectOperations op = this.lockOperation(p);
        try {
            ArrayList<Reloader> requests;
            ProjectReloadInternal s = this;
            synchronized (s) {
                this.stateIdentity.reap();
                requests = new ArrayList<Reloader>(op.pendingReloads);
            }
            for (Reloader pr : requests) {
                if (!ProjectReloadInternal.satisfies(p, stateRequest, pr.request, pr.originalState)) continue;
                LOG.log(Level.FINE, "Request {0} coalesced with {1}", new Object[]{pr, stateRequest});
                CompletableFuture<ProjectReload.ProjectState> completableFuture = pr.clientFuture;
                return completableFuture;
            }
            Reloader reload = new Reloader(p, stateRequest, refCurrent, impls.allInstances(), this, origin);
            Object object = this;
            synchronized (object) {
                op.pendingReloads.add(reload);
                LOG.log(Level.FINE, "START: project {0} load with request {1}, reload {2}", new Object[]{p, stateRequest, reload});
            }
            object = reload.clientFuture;
            return object;
        }
        finally {
            this.endOperation(p, null, null);
        }
    }

    private synchronized ProjectOperations lockOperation(Project p) {
        ProjectOperations op = this.pendingOperations.computeIfAbsent(p, x -> new ProjectOperations());
        ++op.usage;
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runProjectAction(Project p, Runnable r) {
        ProjectReloadInternal projectReloadInternal = this;
        synchronized (projectReloadInternal) {
            ProjectOperations op = this.pendingOperations.get(p);
            if (op != null && op.usage > 0) {
                LOG.log(Level.FINE, "ACTION: Postponed {0} / {1}", new Object[]{p, r});
                op.postponedActions.add(r);
                return;
            }
        }
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoOperations() {
        ProjectReloadInternal projectReloadInternal = this;
        synchronized (projectReloadInternal) {
            HashMap<Project, ProjectOperations> ops = new HashMap<Project, ProjectOperations>(this.pendingOperations);
            ops.values().removeAll(this.terminatingOperations);
            if (!ops.isEmpty()) {
                System.err.println("Pending operations detected");
                for (Map.Entry en : ops.entrySet()) {
                    ProjectOperations op = (ProjectOperations)en.getValue();
                    System.err.println(String.valueOf(en.getKey()) + ": usage " + op.usage + ", pendingReloads: " + op.pendingReloads.size() + ", actions: " + op.postponedActions.size());
                    for (Reloader r : op.pendingReloads) {
                        r.getOriginTrace().printStackTrace();
                    }
                }
            }
            if (!ops.isEmpty() || this.loaderProcessors.size() != PROJECT_RELOAD_CONCURRENCY) {
                throw new IllegalStateException();
            }
        }
    }

    private Collection<IdentityHolder> collectReleases(ProjectOperations op) {
        Collection<IdentityHolder> releases = op.releases;
        releases.removeIf(expired -> {
            ProjectReloadImplementation.ProjectStateData d = expired.state.get();
            if (d == null) {
                return true;
            }
            IdentityHolder h = this.stateIdentity.get(d);
            return h != null && h != expired;
        });
        op.releases = new ArrayList<IdentityHolder>();
        return releases;
    }

    private void notityReleased(IdentityHolder h) {
        ProjectReloadImplementation.ProjectStateData d = h.state.get();
        if (d != null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "CLEAN: Cleaning state: {0} with impl {1}", new Object[]{d.toString(), h.impl});
            }
            h.impl.projectDataReleased(d);
            ReloadSpiAccessor.get().release(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOperation(Project p, Reloader reload, Runnable futureCompleter) {
        Reloader nextReloader;
        Collection<Runnable> postponedActions;
        ProjectOperations op;
        Collection<Object> releases = Collections.emptyList();
        ProjectReloadInternal projectReloadInternal = this;
        synchronized (projectReloadInternal) {
            op = this.pendingOperations.get(p);
            if (op == null) {
                throw new IllegalArgumentException();
            }
            if (reload != null && !op.removeReloader(reload)) {
                return;
            }
            --op.usage;
            if (op.usage > 0) {
                return;
            }
            ++op.usage;
            postponedActions = op.postponedActions;
            op.postponedActions = new ArrayList<Runnable>();
            nextReloader = op.nextReloader();
            if (nextReloader != null) {
                ++op.usage;
            } else {
                releases = this.collectReleases(op);
            }
            this.terminatingOperations.add(op);
        }
        LOG.log(Level.FINE, "ACTION: {0}: processing postponed actions", p);
        releases.forEach(this::notityReleased);
        if (futureCompleter != null) {
            futureCompleter.run();
        }
        postponedActions.forEach(Runnable::run);
        releases = null;
        postponedActions = null;
        projectReloadInternal = this;
        synchronized (projectReloadInternal) {
            this.terminatingOperations.remove(op);
            if (nextReloader == null) {
                nextReloader = op.nextReloader();
                if (nextReloader == null && --op.usage == 0) {
                    this.pendingOperations.remove(p);
                    releases = op.releases;
                    postponedActions = op.postponedActions;
                }
            } else {
                --op.usage;
            }
        }
        if (releases != null) {
            releases.forEach(this::notityReleased);
            postponedActions.forEach(Runnable::run);
        }
        if (nextReloader == null) {
            return;
        }
        Reloader fNextReloader = nextReloader;
        LOG.log(Level.FINE, "RELOAD-START: Project {0}: starting reload {1} with request {2}", new Object[]{p, nextReloader, nextReloader.request});
        this.dispatcher.post(() -> {
            RequestProcessor loader = null;
            while (loader == null) {
                try {
                    loader = this.loaderProcessors.take();
                }
                catch (InterruptedException interruptedException) {}
            }
            RequestProcessor floader = loader;
            CompletionStage f = CompletableFuture.runAsync(() -> fNextReloader.initRound(), (Executor)loader).thenCompose(v -> fNextReloader.start(floader));
            ((CompletableFuture)f).whenCompleteAsync((result, err) -> {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "ACTION: Return RP {0} to the pool after {1}", new Object[]{floader, fNextReloader});
                }
                this.loaderProcessors.offer(floader);
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "COMPLETING: project {0} with request {1}, loader {2}", new Object[]{fNextReloader.project, fNextReloader.request, fNextReloader});
                    }
                    this.endOperation(fNextReloader.project, fNextReloader, () -> {
                        if (err == null) {
                            fNextReloader.completePending.completeAsync(() -> result, (Executor)RELOAD_RP);
                        } else {
                            RELOAD_RP.post(() -> fNextReloader.completePending.completeExceptionally((Throwable)err));
                        }
                    });
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                }
            }, (Executor)floader);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCleanup(IdentityHolder expired) {
        IdentityHolder h;
        ProjectReloadImplementation.ProjectStateData d = expired.state.get();
        if (d == null) {
            return;
        }
        ProjectReloadInternal projectReloadInternal = this;
        synchronized (projectReloadInternal) {
            h = this.stateIdentity.get(d);
            if (h != null && h != expired) {
                return;
            }
            this.stateIdentity.remove(d);
            ProjectOperations op = this.pendingOperations.get(h.project);
            if (op != null && op.usage > 0) {
                op.releases.add(h);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "ACTION: Postponing cleanup: {0} with impl {1}", new Object[]{d.toString(), h.impl});
                }
                return;
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "ACTION: cleaning {0} with impl {1}", new Object[]{d.toString(), h.impl});
        }
        h.impl.projectDataReleased(d);
        ReloadSpiAccessor.get().release(d);
    }

    synchronized Object identity(Project p, ProjectReloadImplementation impl, ProjectReloadImplementation.ProjectStateData sd) {
        Object o;
        IdentityHolder h = this.stateIdentity.get(sd);
        if (h != null && (o = h.get()) != null) {
            return o;
        }
        o = new Object();
        this.stateIdentity.put(sd, new IdentityHolder(p, impl, sd, o));
        return o;
    }

    synchronized boolean hasIdentity(ProjectReloadImplementation.ProjectStateData sd) {
        return this.stateIdentity.get(sd) != null;
    }

    static {
        RELOAD_RP = new RequestProcessor(ProjectReloadInternal.class.getName() + ".reload");
        NOTIFIER = new RequestProcessor(ProjectReloadInternal.class.getName() + ".events");
        STATE_CLEANER = new RequestProcessor(ProjectReload.class.getName());
        STATE_CACHE = new HashMap<Collection, StateRef>();
        EMPTY_PARTS = new StatePartsImpl();
    }

    private static class HashList
    extends ArrayList {
        private int h;

        @Override
        public int hashCode() {
            if (this.h == 0) {
                int h2 = super.hashCode();
                this.h = h2 == 0 ? -1 : h2;
            }
            return this.h;
        }
    }

    public static interface StateParts
    extends Map<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData<?>> {
    }

    public static final class StateRef
    extends WeakReference<ProjectReload.ProjectState>
    implements Runnable {
        private final RequestProcessor.Task evictTask = STATE_CLEANER.create((Runnable)this);
        final Collection variantKey;
        private volatile long lastAccessed;
        private volatile ProjectReload.ProjectState hard;
        StateDataListener toDetach;

        StateRef(Collection variant, ProjectReload.ProjectState referent) {
            super(referent, BaseUtilities.activeReferenceQueue());
            this.variantKey = variant;
        }

        public ProjectReload.ProjectState touch() {
            ProjectReload.ProjectState o = this.hard;
            if (o == null) {
                o = (ProjectReload.ProjectState)super.get();
            }
            if (o != null) {
                long m = System.currentTimeMillis();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Project touched: {0}@{3} at {1}, lastAccessed = {2}", new Object[]{o.toString(), m, this.lastAccessed, Integer.toHexString(System.identityHashCode(this))});
                }
                this.hard = o;
                if (this.lastAccessed == 0L) {
                    this.evictTask.schedule(5000);
                }
                this.lastAccessed = m;
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.hard == null) {
                Object object = STATE_CACHE;
                synchronized (object) {
                    STATE_CACHE.remove(this.variantKey);
                }
                object = this;
                synchronized (object) {
                    if (this.toDetach == null) {
                        LOG.log(Level.FINER, "Project state GCed: {0}", Integer.toHexString(System.identityHashCode(this)));
                        return;
                    }
                }
                LOG.log(Level.FINER, "Project state {0}: detaching listeners", Integer.toHexString(System.identityHashCode(this)));
                this.toDetach.detachListeners();
            } else {
                long unused = System.currentTimeMillis() - this.lastAccessed;
                if (unused > 2500L) {
                    this.hard = null;
                    this.lastAccessed = 0L;
                } else {
                    this.evictTask.schedule(5000 - (int)unused);
                }
            }
        }
    }

    static class StatePartsImpl
    extends LinkedHashMap<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData<?>>
    implements StateParts {
        public StatePartsImpl() {
        }

        public StatePartsImpl(Map<? extends ProjectReloadImplementation<?>, ? extends ProjectReloadImplementation.ProjectStateData<?>> m) {
            super(m);
        }
    }

    private static class ProjectOperations {
        int usage;
        Collection<IdentityHolder> releases = new ArrayList<IdentityHolder>();
        Collection<Reloader> pendingReloads = new ArrayList<Reloader>();
        Collection<Runnable> postponedActions = new ArrayList<Runnable>();
        Reloader currentReload;

        private ProjectOperations() {
        }

        Reloader nextReloader() {
            if (this.pendingReloads.isEmpty()) {
                return null;
            }
            this.currentReload = this.pendingReloads.iterator().next();
            return this.currentReload;
        }

        boolean removeReloader(Reloader r) {
            if (r != null && this.currentReload == r) {
                this.currentReload = null;
            }
            return r == null || this.pendingReloads.remove(r);
        }
    }

    private class IdentityHolder
    extends WeakReference
    implements Runnable {
        private final Project project;
        private final ProjectReloadImplementation impl;
        private final Reference<ProjectReloadImplementation.ProjectStateData> state;

        public IdentityHolder(Project p, ProjectReloadImplementation impl, ProjectReloadImplementation.ProjectStateData state, Object o) {
            super(o, BaseUtilities.activeReferenceQueue());
            this.project = p;
            this.impl = impl;
            this.state = new WeakReference<ProjectReloadImplementation.ProjectStateData>(state);
        }

        @Override
        public void run() {
            ProjectReloadInternal.this.postCleanup(this);
        }
    }
}

