/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lsp;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lsp.SignatureInformation;
import org.netbeans.modules.lsp.SignatureInformationAccessor;
import org.netbeans.spi.editor.mimelookup.MimeLocation;

@MimeLocation(subfolderName="SignatureHelpProviders")
public interface SignatureInformationCollector {
    public void collectSignatureInformation(@NonNull Document var1, int var2, @NullAllowed SignatureInformation.Context var3, @NonNull Consumer<SignatureInformation> var4);

    public static Builder newBuilder(@NonNull String label, boolean isActive) {
        return new Builder(label, isActive);
    }

    public static final class Builder {
        private final String label;
        private final List<SignatureInformation.ParameterInformation> params;
        private final boolean isActive;
        private String documentation;

        private Builder(@NonNull String label, boolean isActive) {
            this.label = label;
            this.isActive = isActive;
            this.params = new ArrayList<SignatureInformation.ParameterInformation>();
        }

        @NonNull
        public Builder documentation(@NonNull String documentation) {
            this.documentation = documentation;
            return this;
        }

        @NonNull
        public Builder addParameter(@NonNull String label, boolean isActive, @NullAllowed String documentation) {
            this.params.add(SignatureInformationAccessor.getDefault().createParameterInformation(label, isActive, documentation));
            return this;
        }

        @NonNull
        public SignatureInformation build() {
            return SignatureInformationAccessor.getDefault().createSignatureInformation(this.label, this.params, this.isActive, this.documentation);
        }
    }
}

