/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTagNamespaceRequest
extends BmcRequest<Void> {
    private String tagNamespaceId;

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public Builder toBuilder() {
        return new Builder().tagNamespaceId(this.tagNamespaceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tagNamespaceId=").append(String.valueOf(this.tagNamespaceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTagNamespaceRequest)) {
            return false;
        }
        GetTagNamespaceRequest other = (GetTagNamespaceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tagNamespaceId, other.tagNamespaceId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tagNamespaceId == null ? 43 : this.tagNamespaceId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTagNamespaceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tagNamespaceId = null;

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTagNamespaceRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTagNamespaceRequest build() {
            GetTagNamespaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTagNamespaceRequest buildWithoutInvocationCallback() {
            GetTagNamespaceRequest request = new GetTagNamespaceRequest();
            request.tagNamespaceId = this.tagNamespaceId;
            return request;
        }
    }
}

