/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDynamicGroupRequest
extends BmcRequest<Void> {
    private String dynamicGroupId;

    public String getDynamicGroupId() {
        return this.dynamicGroupId;
    }

    public Builder toBuilder() {
        return new Builder().dynamicGroupId(this.dynamicGroupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dynamicGroupId=").append(String.valueOf(this.dynamicGroupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDynamicGroupRequest)) {
            return false;
        }
        GetDynamicGroupRequest other = (GetDynamicGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dynamicGroupId, other.dynamicGroupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dynamicGroupId == null ? 43 : this.dynamicGroupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDynamicGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dynamicGroupId = null;

        public Builder dynamicGroupId(String dynamicGroupId) {
            this.dynamicGroupId = dynamicGroupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDynamicGroupRequest o) {
            this.dynamicGroupId(o.getDynamicGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDynamicGroupRequest build() {
            GetDynamicGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDynamicGroupRequest buildWithoutInvocationCallback() {
            GetDynamicGroupRequest request = new GetDynamicGroupRequest();
            request.dynamicGroupId = this.dynamicGroupId;
            return request;
        }
    }
}

