/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteGroupRequest
extends BmcRequest<Void> {
    private String groupId;
    private String ifMatch;

    public String getGroupId() {
        return this.groupId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().groupId(this.groupId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",groupId=").append(String.valueOf(this.groupId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteGroupRequest)) {
            return false;
        }
        DeleteGroupRequest other = (DeleteGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.groupId == null ? 43 : this.groupId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String groupId = null;
        private String ifMatch = null;

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteGroupRequest o) {
            this.groupId(o.getGroupId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteGroupRequest build() {
            DeleteGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteGroupRequest buildWithoutInvocationCallback() {
            DeleteGroupRequest request = new DeleteGroupRequest();
            request.groupId = this.groupId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

