/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.atoum.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AtoumOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -138100563143476L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel atoumPathHintLabel;
    private JLabel atoumPathLabel;
    private JTextField atoumPathTextField;
    private JButton browseAtoumButton;
    private JLabel errorLabel;
    private JLabel installLabel;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton searchAtoumButton;

    public AtoumOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.atoumPathHintLabel.setText(Bundle.AtoumOptionsPanel_atoum_hint("mageekguy.atoum.phar", "atoum"));
        this.atoumPathTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public String getAtoumPath() {
        return this.atoumPathTextField.getText();
    }

    public void setAtoumPath(String path) {
        this.atoumPathTextField.setText(path);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.atoumPathLabel = new JLabel();
        this.atoumPathTextField = new JTextField();
        this.browseAtoumButton = new JButton();
        this.searchAtoumButton = new JButton();
        this.atoumPathHintLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.installLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.atoumPathLabel.setLabelFor(this.atoumPathTextField);
        Mnemonics.setLocalizedText((JLabel)this.atoumPathLabel, (String)NbBundle.getMessage(AtoumOptionsPanel.class, (String)"AtoumOptionsPanel.atoumPathLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseAtoumButton, (String)NbBundle.getMessage(AtoumOptionsPanel.class, (String)"AtoumOptionsPanel.browseAtoumButton.text"));
        this.browseAtoumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtoumOptionsPanel.this.browseAtoumButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchAtoumButton, (String)NbBundle.getMessage(AtoumOptionsPanel.class, (String)"AtoumOptionsPanel.searchAtoumButton.text"));
        this.searchAtoumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtoumOptionsPanel.this.searchAtoumButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.atoumPathHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(AtoumOptionsPanel.class, (String)"AtoumOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(AtoumOptionsPanel.class, (String)"AtoumOptionsPanel.installLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(AtoumOptionsPanel.class, (String)"AtoumOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AtoumOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                AtoumOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.atoumPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.atoumPathHintLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.atoumPathTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseAtoumButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchAtoumButton)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installLabel).addComponent(this.learnMoreLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.errorLabel)).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.browseAtoumButton, this.searchAtoumButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atoumPathLabel).addComponent(this.atoumPathTextField, -2, -1, -2).addComponent(this.browseAtoumButton).addComponent(this.searchAtoumButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.atoumPathHintLabel).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void browseAtoumButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(AtoumOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.AtoumOptionsPanel_atoum_browse_title()).showOpenDialog();
        if (file != null) {
            this.atoumPathTextField.setText(file.getAbsolutePath());
        }
    }

    private void searchAtoumButtonActionPerformed(ActionEvent evt) {
        String atoum = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"mageekguy.atoum.phar", "atoum"});
            }

            public String getWindowTitle() {
                return Bundle.AtoumOptionsPanel_atoum_search_title();
            }

            public String getListTitle() {
                return Bundle.AtoumOptionsPanel_atoum_search_files();
            }

            public String getPleaseWaitPart() {
                return Bundle.AtoumOptionsPanel_atoum_search_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.AtoumOptionsPanel_atoum_search_notFound();
            }
        });
        if (atoum != null) {
            this.atoumPathTextField.setText(atoum);
        }
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/atoum/atoum");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            AtoumOptionsPanel.this.fireChange();
        }
    }
}

