/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.run;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.php.atoum.run.TestCaseVo;
import org.netbeans.modules.php.atoum.run.TestSuiteVo;
import org.netbeans.modules.php.spi.testing.run.TestCase;

public final class TapParser {
    static final Logger LOGGER = Logger.getLogger(TapParser.class.getName());
    private static final Pattern FILE_LINE_PATTERN = Pattern.compile("(.+):(\\d+)");
    private static final Pattern SUITE_TEST_PATTERN = Pattern.compile("([^:\\s]+)::([^\\(]+)\\(\\)");
    private final List<TestSuiteVo> testSuites = new ArrayList<TestSuiteVo>();
    private final List<String> commentLines = new ArrayList<String>();
    private TestSuiteVo testSuite = null;
    private TestCaseVo testCase = null;
    private int testCaseCount = 0;
    private State state = null;

    public static boolean isTestCaseStart(String line) {
        return line.startsWith("ok ") || line.startsWith("not ok ");
    }

    public List<TestSuiteVo> parse(String input, long runtime) {
        for (String line : input.split("\\r?\\n|\\r")) {
            this.parseLine(line.trim());
        }
        this.processNotOkLines();
        this.setTimes(runtime);
        return this.testSuites;
    }

    private void parseLine(String line) {
        if (line.startsWith("1..")) {
            return;
        }
        if (line.startsWith("ok ")) {
            this.processNotOkLines();
            assert (this.state == null) : this.state;
            if (this.checkSkipped(line)) {
                this.state = State.OK_SKIP;
                this.testCase.setStatus(TestCase.Status.SKIPPED);
            } else {
                this.state = State.OK;
                this.testCase = null;
            }
        } else if (line.startsWith("not ok ")) {
            this.processNotOkLines();
            assert (this.state == null) : this.state;
            this.state = State.NOT_OK;
            this.setSuiteTest(line);
            this.testCase.setStatus(TestCase.Status.FAILED);
            this.checkTodo(line);
        } else {
            this.processComment(line);
        }
    }

    private boolean checkSkipped(String line) {
        assert (this.state == null) : this.state;
        if (line.contains("# SKIP ")) {
            this.setSuiteTest(line);
            return true;
        }
        return false;
    }

    private void checkTodo(String line) {
        assert (this.state == State.NOT_OK) : this.state;
        if (line.contains("# TODO ")) {
            this.testCase.setStatus(TestCase.Status.PENDING);
        }
    }

    private void processComment(String line) {
        assert (line.startsWith("#")) : line;
        line = line.substring(1).trim();
        switch (this.state.ordinal()) {
            case 0: {
                this.setSuiteTest(line);
                this.testCase.setStatus(TestCase.Status.PASSED);
                this.state = null;
                break;
            }
            case 1: {
                this.commentLines.add(line);
                break;
            }
            case 2: {
                this.commentLines.add(line);
                break;
            }
            default: {
                assert (false) : "Unknown state: " + (Object)((Object)this.state);
                break;
            }
        }
    }

    private void processNotOkLines() {
        if (this.commentLines.isEmpty()) {
            return;
        }
        assert (this.testCase != null);
        int lastIndex = this.commentLines.size() - 1;
        String lastLine = this.commentLines.get(lastIndex);
        if (this.setFileLine(lastLine)) {
            this.commentLines.remove(lastIndex);
        } else {
            if (lastLine.toLowerCase().endsWith(".php")) {
                this.commentLines.remove(lastIndex);
                this.testCase.setFile(lastLine);
            }
            if (this.testCase.getStatus() == TestCase.Status.FAILED) {
                this.testCase.setStatus(TestCase.Status.ERROR);
            }
        }
        StringBuilder message = null;
        ArrayList<String> stackTrace = new ArrayList<String>();
        while (!this.commentLines.isEmpty()) {
            String firstLine = this.commentLines.get(0);
            this.commentLines.remove(0);
            if (firstLine.equals("Stack trace:")) {
                this.testCase.setStatus(TestCase.Status.ERROR);
                stackTrace.addAll(this.processStackTrace(this.commentLines));
                this.commentLines.clear();
                continue;
            }
            if (firstLine.equals("-Reference") || firstLine.equals("-Expected")) {
                this.processDiff(this.commentLines);
                this.commentLines.clear();
                continue;
            }
            if (message == null) {
                message = new StringBuilder(200);
            }
            if (message.length() > 0) {
                message.append("; ");
            }
            message.append(firstLine);
        }
        String msg = null;
        if (message != null) {
            msg = message.toString();
            this.testCase.setMessage(msg);
        }
        if (!lastLine.equals(msg)) {
            stackTrace.add(lastLine);
        }
        this.testCase.setStackTrace(stackTrace);
        this.state = null;
    }

    private List<String> processStackTrace(List<String> lines) {
        ArrayList<String> stackTrace = new ArrayList<String>(lines.size());
        for (String line : lines) {
            assert (line.startsWith("#")) : line;
            stackTrace.add(line.substring(3));
        }
        return stackTrace;
    }

    private void processDiff(List<String> lines) {
        StringBuilder diffExpected = new StringBuilder(200);
        StringBuilder diffActual = new StringBuilder(200);
        boolean diff = false;
        for (String line : lines) {
            if (line.startsWith("@@")) {
                diff = true;
                continue;
            }
            if (!diff) continue;
            if (line.startsWith("+")) {
                if (diffActual.length() > 0) {
                    diffActual.append("\n");
                }
                diffActual.append(line.substring(1));
                continue;
            }
            if (line.startsWith("-")) {
                if (diffExpected.length() > 0) {
                    diffExpected.append("\n");
                }
                diffExpected.append(line.substring(1));
                continue;
            }
            LOGGER.log(Level.INFO, "Unexpected DIFF line {0}", line);
        }
        this.testCase.setDiff(new TestCase.Diff(diffExpected.toString(), diffActual.toString()));
    }

    private void setSuiteTest(String line) {
        Matcher matcher = SUITE_TEST_PATTERN.matcher(line);
        boolean found = matcher.find();
        assert (found) : line;
        String suiteName = matcher.group(1);
        String testName = matcher.group(2);
        if (this.testSuite == null || !this.testSuite.getName().equals(suiteName)) {
            this.testSuite = new TestSuiteVo(suiteName);
            this.testSuites.add(this.testSuite);
        }
        assert (this.testSuite != null);
        assert (suiteName.equals(this.testSuite.getName())) : this.testSuite;
        this.testCase = new TestCaseVo(testName);
        this.testSuite.addTestCase(this.testCase);
        ++this.testCaseCount;
    }

    private boolean setFileLine(String line) {
        Matcher matcher = FILE_LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return false;
        }
        assert (this.testCase != null);
        String file = matcher.group(1);
        String fileLine = matcher.group(2);
        assert (file != null) : line;
        this.testCase.setFile(file);
        assert (fileLine != null) : line;
        this.testCase.setLine(Integer.parseInt(fileLine));
        return true;
    }

    private void setTimes(long runtime) {
        long time = 0L;
        if (this.testCaseCount > 0) {
            time = runtime / (long)this.testCaseCount;
        }
        for (TestSuiteVo suite : this.testSuites) {
            for (TestCaseVo kase : suite.getTestCases()) {
                kase.setTime(time);
            }
        }
    }

    private static enum State {
        OK,
        OK_SKIP,
        NOT_OK;

    }
}

