/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.preferences;

import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.atoum.preferences.AtoumPreferences;
import org.netbeans.modules.php.atoum.preferences.Bundle;
import org.netbeans.modules.php.atoum.util.AtoumUtils;

public final class AtoumPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public AtoumPreferencesValidator validate(PhpModule phpModule) {
        this.validateBootstrap(AtoumPreferences.isBootstrapEnabled(phpModule), AtoumPreferences.getBootstrapPath(phpModule));
        this.validateConfiguration(AtoumPreferences.isConfigurationEnabled(phpModule), AtoumPreferences.getConfigurationPath(phpModule));
        this.validateAtoum(AtoumPreferences.isAtoumEnabled(phpModule), AtoumPreferences.getAtoumPath(phpModule));
        return this;
    }

    public AtoumPreferencesValidator validateBootstrap(boolean bootstrapEnabled, String bootstrapPath) {
        this.validatePath(bootstrapEnabled, bootstrapPath, Bundle.AtoumPreferencesValidator_bootstrap_label(), "bootstrap.path");
        return this;
    }

    public AtoumPreferencesValidator validateConfiguration(boolean configurationEnabled, String configurationPath) {
        this.validatePath(configurationEnabled, configurationPath, Bundle.AtoumPreferencesValidator_configuration_label(), "configuration.path");
        return this;
    }

    public AtoumPreferencesValidator validateAtoum(boolean atoumEnabled, String atoumPath) {
        String warning;
        if (atoumEnabled && (warning = AtoumUtils.validateAtoumPath(atoumPath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"atoum.path", warning));
        }
        return this;
    }

    private void validatePath(boolean pathEnabled, String path, String label, String source) {
        if (!pathEnabled) {
            return;
        }
        String warning = FileUtils.validateFile((String)label, (String)path, (boolean)false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)source, warning));
        }
    }
}

