/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.refactoring.php.Bundle;
import org.netbeans.modules.refactoring.php.RefactoringUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public abstract class RefactoringTask
extends UserTask
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(RefactoringTask.class);
    private static final Logger LOG = Logger.getLogger(RefactoringTask.class.getName());
    RefactoringUIHolder uiHolder = RefactoringUIHolder.NONE;

    protected void fetchRefactoringUI(Source source, UserTask userTask) {
        Future futureTask = RP.submit((Runnable)new ParsingTask(source, userTask));
        boolean parsingInProgress = false;
        try {
            futureTask.get(2500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        catch (TimeoutException ex) {
            futureTask.cancel(true);
            parsingInProgress = true;
        }
        this.uiHolder.processUI(parsingInProgress);
    }

    static interface RefactoringUIHolder {
        public static final RefactoringUIHolder NONE = new RefactoringUIHolder(){

            @Override
            public void processUI(boolean parsingInProgress) {
                if (parsingInProgress) {
                    JOptionPane.showMessageDialog(null, Bundle.ERR_ParsingInProgress());
                } else {
                    JOptionPane.showMessageDialog(null, Bundle.ERR_CannotRefactorLoc());
                }
            }
        };
        public static final RefactoringUIHolder NOT_USERS_FILE = new RefactoringUIHolder(){

            @Override
            public void processUI(boolean parsingInProgress) {
                JOptionPane.showMessageDialog(null, Bundle.ERR_ElementNotInUsersFile());
            }
        };

        public void processUI(boolean var1);
    }

    private static final class ParsingTask
    implements Runnable,
    Cancellable {
        private final Source source;
        private final UserTask userTask;
        private volatile boolean cancelled;
        private volatile Future<Void> future;

        private ParsingTask(Source source, UserTask userTask) {
            this.source = source;
            this.userTask = userTask;
        }

        @Override
        public void run() {
            try {
                if (!this.cancelled) {
                    this.future = ParserManager.parseWhenScanFinished(Collections.singleton(this.source), (UserTask)this.userTask);
                }
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(true);
            }
            return true;
        }
    }

    static abstract class TextComponentTask
    extends RefactoringTask {
        private final JTextComponent textC;
        private final int caret;
        private final Document document;

        public TextComponentTask(EditorCookie ec) {
            this.textC = ec.getOpenedPanes()[0];
            this.document = this.textC.getDocument();
            this.caret = this.textC.getCaretPosition();
            assert (this.caret != -1);
        }

        @Override
        public void run() {
            this.fetchRefactoringUI(Source.create((Document)this.document), this);
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Program root;
            Parser.Result parserResult = resultIterator.getParserResult();
            if (parserResult instanceof PHPParseResult && (root = RefactoringUtils.getRoot((ParserResult)((PHPParseResult)parserResult))) != null) {
                this.uiHolder = this.createRefactoringUI((PHPParseResult)parserResult, this.caret);
                return;
            }
            LOG.log(Level.FINE, "FAILURE - can't refactor uncompileable sources");
        }

        protected abstract RefactoringUIHolder createRefactoringUI(PHPParseResult var1, int var2);
    }

    static abstract class NodeToFileTask
    extends RefactoringTask {
        private final Node node;
        private FileObject fileObject;

        public NodeToFileTask(Node node) {
            this.node = node;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Program root;
            Parser.Result parserResult = resultIterator.getParserResult();
            if (parserResult instanceof PHPParseResult && (root = RefactoringUtils.getRoot((ParserResult)((PHPParseResult)parserResult))) != null) {
                this.uiHolder = this.createRefactoringUIHolder((PHPParseResult)parserResult);
                return;
            }
            LOG.log(Level.FINE, "FAILURE - can't refactor uncompileable sources");
        }

        @Override
        public void run() {
            DataObject dobj = (DataObject)this.node.getLookup().lookup(DataObject.class);
            if (dobj != null) {
                this.fileObject = dobj.getPrimaryFile();
                if (this.fileObject.isFolder()) {
                    JOptionPane.showMessageDialog(null, Bundle.ERR_CannotRefactorLoc());
                } else {
                    this.fetchRefactoringUI(Source.create((FileObject)this.fileObject), this);
                }
            }
        }

        protected abstract RefactoringUIHolder createRefactoringUIHolder(PHPParseResult var1);
    }
}

