/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.RestoreVaultFromObjectStoreDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RestoreVaultFromObjectStoreRequest
extends BmcRequest<RestoreVaultFromObjectStoreDetails> {
    private String compartmentId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private RestoreVaultFromObjectStoreDetails restoreVaultFromObjectStoreDetails;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public RestoreVaultFromObjectStoreDetails getRestoreVaultFromObjectStoreDetails() {
        return this.restoreVaultFromObjectStoreDetails;
    }

    @InternalSdk
    public RestoreVaultFromObjectStoreDetails getBody$() {
        return this.restoreVaultFromObjectStoreDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).restoreVaultFromObjectStoreDetails(this.restoreVaultFromObjectStoreDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",restoreVaultFromObjectStoreDetails=").append(String.valueOf((Object)this.restoreVaultFromObjectStoreDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestoreVaultFromObjectStoreRequest)) {
            return false;
        }
        RestoreVaultFromObjectStoreRequest other = (RestoreVaultFromObjectStoreRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.restoreVaultFromObjectStoreDetails, (Object)other.restoreVaultFromObjectStoreDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.restoreVaultFromObjectStoreDetails == null ? 43 : this.restoreVaultFromObjectStoreDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreVaultFromObjectStoreRequest, RestoreVaultFromObjectStoreDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private RestoreVaultFromObjectStoreDetails restoreVaultFromObjectStoreDetails = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder restoreVaultFromObjectStoreDetails(RestoreVaultFromObjectStoreDetails restoreVaultFromObjectStoreDetails) {
            this.restoreVaultFromObjectStoreDetails = restoreVaultFromObjectStoreDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreVaultFromObjectStoreRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.restoreVaultFromObjectStoreDetails(o.getRestoreVaultFromObjectStoreDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreVaultFromObjectStoreRequest build() {
            RestoreVaultFromObjectStoreRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RestoreVaultFromObjectStoreDetails body) {
            this.restoreVaultFromObjectStoreDetails(body);
            return this;
        }

        public RestoreVaultFromObjectStoreRequest buildWithoutInvocationCallback() {
            RestoreVaultFromObjectStoreRequest request = new RestoreVaultFromObjectStoreRequest();
            request.compartmentId = this.compartmentId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.restoreVaultFromObjectStoreDetails = this.restoreVaultFromObjectStoreDetails;
            return request;
        }
    }
}

