/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KeyShape
extends ExplicitlySetBmcModel {
    @JsonProperty(value="algorithm")
    private final Algorithm algorithm;
    @JsonProperty(value="length")
    private final Integer length;
    @JsonProperty(value="curveId")
    private final CurveId curveId;

    @Deprecated
    @ConstructorProperties(value={"algorithm", "length", "curveId"})
    public KeyShape(Algorithm algorithm, Integer length, CurveId curveId) {
        this.algorithm = algorithm;
        this.length = length;
        this.curveId = curveId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Integer getLength() {
        return this.length;
    }

    public CurveId getCurveId() {
        return this.curveId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyShape(");
        sb.append("super=").append(super.toString());
        sb.append("algorithm=").append(String.valueOf((Object)this.algorithm));
        sb.append(", length=").append(String.valueOf(this.length));
        sb.append(", curveId=").append(String.valueOf((Object)this.curveId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyShape)) {
            return false;
        }
        KeyShape other = (KeyShape)((Object)o);
        return Objects.equals((Object)this.algorithm, (Object)other.algorithm) && Objects.equals(this.length, other.length) && Objects.equals((Object)this.curveId, (Object)other.curveId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.algorithm == null ? 43 : this.algorithm.hashCode());
        result = result * 59 + (this.length == null ? 43 : this.length.hashCode());
        result = result * 59 + (this.curveId == null ? 43 : this.curveId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CurveId implements BmcEnum
    {
        NistP256("NIST_P256"),
        NistP384("NIST_P384"),
        NistP521("NIST_P521"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CurveId> map;

        private CurveId(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CurveId create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CurveId', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CurveId.class);
            map = new HashMap<String, CurveId>();
            for (CurveId v : CurveId.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Algorithm implements BmcEnum
    {
        Aes("AES"),
        Rsa("RSA"),
        Ecdsa("ECDSA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Algorithm', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Algorithm.class);
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="algorithm")
        private Algorithm algorithm;
        @JsonProperty(value="length")
        private Integer length;
        @JsonProperty(value="curveId")
        private CurveId curveId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            this.__explicitlySet__.add("length");
            return this;
        }

        public Builder curveId(CurveId curveId) {
            this.curveId = curveId;
            this.__explicitlySet__.add("curveId");
            return this;
        }

        public KeyShape build() {
            KeyShape model = new KeyShape(this.algorithm, this.length, this.curveId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KeyShape model) {
            if (model.wasPropertyExplicitlySet("algorithm")) {
                this.algorithm(model.getAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("length")) {
                this.length(model.getLength());
            }
            if (model.wasPropertyExplicitlySet("curveId")) {
                this.curveId(model.getCurveId());
            }
            return this;
        }
    }
}

