/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.pull.Bundle;
import org.netbeans.modules.mercurial.ui.queues.QGoToPatchAction;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class FetchAction
extends ContextAction {
    public static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/resources/icons/fetch.png";

    public FetchAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_FetchLocal";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        String name = roots.size() == 1 ? "CTL_MenuItem_FetchRoot" : "CTL_MenuItem_FetchLocal";
        return roots.size() == 1 ? NbBundle.getMessage(FetchAction.class, (String)name, (Object)roots.iterator().next().getName()) : NbBundle.getMessage(FetchAction.class, (String)name);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<File> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){
            final /* synthetic */ FetchAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Iterator iterator = repositoryRoots.iterator();
                while (iterator.hasNext()) {
                    File repositoryRoot;
                    final File root = repositoryRoot = (File)iterator.next();
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                    HgProgressSupport support = new HgProgressSupport(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void perform() {
                            FetchAction.performFetch(root, null, this);
                        }
                    };
                    support.start(rp, root, NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_PROGRESS")).waitFinished();
                    if (!support.isCanceled()) continue;
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performFetch(final File root, final String revision, final HgProgressSupport supp) {
        final OutputLogger logger = supp.getLogger();
        HgURL pullSource = null;
        try {
            boolean enableFetch;
            final QPatch topPatch = FetchAction.selectPatch(root);
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE"));
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE_SEP"));
            HgConfigFiles config = new HgConfigFiles(root);
            String pullSourceString = config.getDefaultPull(true);
            if (HgUtils.isNullOrEmpty(pullSourceString)) {
                FetchAction.notifyDefaultPullUrlNotSpecified(logger);
                return;
            }
            boolean bl = enableFetch = !config.containsProperty("extensions", "fetch");
            if (enableFetch) {
                HgConfigFiles sysConfig = HgConfigFiles.getSysInstance();
                sysConfig.doReload();
                enableFetch = !sysConfig.containsProperty("extensions", "fetch");
            }
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_LAUNCH_INFO", (Object)root.getAbsolutePath()));
            try {
                pullSource = new HgURL(pullSourceString);
            }
            catch (URISyntaxException ex) {
                File sourceRoot = new File(root, pullSourceString);
                if (sourceRoot.isDirectory()) {
                    pullSource = new HgURL(FileUtil.normalizeFile((File)sourceRoot));
                }
                String msg = NbBundle.getMessage(FetchAction.class, (String)"MSG_DEFAULT_PULL_INVALID", (Object)pullSourceString);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                Mercurial.LOG.log(Level.INFO, null, ex);
                logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
                logger.output("");
                if (pullSource != null) {
                    pullSource.clearPassword();
                }
                return;
            }
            final HgURL from = pullSource;
            final boolean enableExtension = enableFetch;
            HgUtils.runWithoutIndexing(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (topPatch != null) {
                        supp.setDisplayName(Bundle.MSG_FetchAction_popingPatches());
                        ((QGoToPatchAction)SystemAction.get(QGoToPatchAction.class)).popAllPatches(root, logger);
                        supp.setDisplayName(Bundle.MSG_FetchAction_fetching());
                        logger.output("");
                    }
                    if (supp.isCanceled()) {
                        return null;
                    }
                    List<String> list = HgCommand.doFetch(root, from, revision, enableExtension, logger);
                    if (!supp.isCanceled() && list != null && !list.isEmpty()) {
                        logger.output(HgUtils.replaceHttpPassword(list));
                        if (MergeAction.handleMergeOutput(root, list, logger, true) && topPatch != null) {
                            logger.output("");
                            supp.setDisplayName(Bundle.MSG_FetchAction_pushingPatches());
                            ((QGoToPatchAction)SystemAction.get(QGoToPatchAction.class)).applyPatch(root, topPatch.getId(), logger);
                            HgLogMessage parent = HgCommand.getParents(root, null, null).get(0);
                            logger.output("");
                            HgUtils.logHgLog(parent, logger);
                        }
                        Mercurial.getInstance().historyChanged(root);
                        HgUtils.notifyUpdatedFiles(root, list);
                        HgUtils.forceStatusRefresh(root);
                    }
                    return null;
                }
            }, root);
        }
        catch (HgException.HgCommandCanceledException topPatch) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
            logger.output("");
            if (pullSource != null) {
                pullSource.clearPassword();
            }
        }
    }

    static QPatch selectPatch(File root) throws HgException {
        QPatch[] patches = HgCommand.qListSeries(root);
        QPatch topPatch = null;
        for (QPatch patch : patches) {
            if (!patch.isApplied()) continue;
            topPatch = patch;
        }
        if (topPatch != null) {
            Object conf = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_FetchAction_appliedPatches_text(), Bundle.LBL_FetchAction_appliedPatches_title(), 1, 2));
            if (conf == NotifyDescriptor.CANCEL_OPTION) {
                throw new HgException.HgCommandCanceledException("Canceled");
            }
            if (conf == NotifyDescriptor.NO_OPTION) {
                topPatch = null;
            }
        }
        return topPatch;
    }

    private static void notifyDefaultPullUrlNotSpecified(OutputLogger logger) {
        logger.output(NbBundle.getMessage(FetchAction.class, (String)"MSG_NO_DEFAULT_PULL_SET_MSG"));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(FetchAction.class, (String)"MSG_NO_DEFAULT_PULL_SET")));
    }
}

