/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.properties.HgProperties;
import org.netbeans.modules.mercurial.ui.properties.PropertiesPanel;
import org.netbeans.modules.mercurial.ui.properties.PropertiesTable;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertiesAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/resources/icons/properties.png";

    public PropertiesAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Properties";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        PropertiesPanel panel = new PropertiesPanel();
        PropertiesTable propTable = new PropertiesTable(panel.labelForTable, PropertiesTable.PROPERTIES_COLUMNS);
        panel.setPropertiesTable(propTable);
        JComponent component = propTable.getComponent();
        panel.propsPanel.setLayout(new BorderLayout());
        panel.propsPanel.add((Component)component, "Center");
        HgProperties hgProperties = new HgProperties(panel, propTable, root);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(PropertiesAction.class, (String)"CTL_PropertiesDialog_Title", null), true, null);
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(PropertiesAction.class, (String)"CTL_Properties_Action_OK"));
        okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertiesAction.class, (String)"ACSN_Properties_Action_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesAction.class, (String)"ACSD_Properties_Action_OK"));
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(PropertiesAction.class, (String)"CTL_Properties_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertiesAction.class, (String)"ACSN_Properties_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesAction.class, (String)"ACSD_Properties_Action_Cancel"));
        dd.setOptions(new Object[]{okButton, cancelButton});
        dd.setHelpCtx(new HelpCtx(PropertiesAction.class));
        panel.putClientProperty("contentTitle", null);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesAction.class, (String)"ACSD_Properties_Dialog"));
        dialog.pack();
        dialog.setVisible(true);
        if (dd.getValue() == okButton) {
            hgProperties.updateLastSelection();
            hgProperties.setProperties();
        }
    }
}

