/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class SearchHistorySupport {
    public static final String PROVIDED_EXTENSIONS_SEARCH_HISTORY = "ProvidedExtensions.SearchHistorySupport";
    private static final Logger LOG = Logger.getLogger(SearchHistorySupport.class.getName());
    private final File file;

    protected SearchHistorySupport(File file) {
        this.file = file;
    }

    public static SearchHistorySupport getInstance(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return null;
        }
        SearchHistorySupport support = (SearchHistorySupport)fo.getAttribute(PROVIDED_EXTENSIONS_SEARCH_HISTORY);
        return support;
    }

    protected File getFile() {
        return this.file;
    }

    public boolean searchHistory(int line) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in  awt!";
        if (!this.file.exists()) {
            LOG.log(Level.WARNING, "Trying to show history for non-existent file {0}", this.file.getAbsolutePath());
            return false;
        }
        if (!this.file.isFile()) {
            LOG.log(Level.WARNING, "Trying to show history for a folder {0}", this.file.getAbsolutePath());
            return false;
        }
        return this.searchHistoryImpl(line);
    }

    protected abstract boolean searchHistoryImpl(int var1) throws IOException;
}

