/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.model.api.SubResourceLocator;
import org.netbeans.modules.websvc.rest.nodes.OpenCookieFactory;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class SubResourceLocatorNode
extends AbstractNode {
    private String methodName;
    private String uriTemplate;
    private String returnType;
    private static final Image METHOD_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/rest/nodes/resources/method.png");

    public SubResourceLocatorNode(Project project, String className, SubResourceLocator method) {
        this(project, className, method, new InstanceContent());
    }

    private SubResourceLocatorNode(Project project, String className, SubResourceLocator method, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.methodName = method.getName();
        this.uriTemplate = method.getUriTemplate();
        this.returnType = method.getReturnType();
        content.add((Object)this);
        content.add((Object)OpenCookieFactory.create(project, className, this.methodName));
    }

    public String getDisplayName() {
        return this.uriTemplate + " : " + Utils.stripPackageName(this.returnType);
    }

    public String getShortDescription() {
        return this.methodName + "() : " + Utils.stripPackageName(this.returnType);
    }

    public static String getKey(SubResourceLocator method) {
        return method.getUriTemplate() + " : " + method.getReturnType();
    }

    public Image getIcon(int type) {
        return METHOD_BADGE;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), null, SystemAction.get(PropertiesAction.class)};
    }
}

