/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common;

import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;

public final class ProxyUtils {
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final Logger LOGGER = Logger.getLogger(ProxyUtils.class.getName());

    private ProxyUtils() {
    }

    @CheckForNull
    public static String getNonProxyHosts(@NullAllowed Callable<String> nonProxy) {
        String nonProxyHosts;
        String originalNonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        String configuredNonProxyHosts = null;
        if (nonProxy != null) {
            try {
                configuredNonProxyHosts = nonProxy.call();
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        if (configuredNonProxyHosts != null && !configuredNonProxyHosts.isEmpty() && !(nonProxyHosts = originalNonProxyHosts != null ? ProxyUtils.compactNonProxyHosts(originalNonProxyHosts + "," + configuredNonProxyHosts) : configuredNonProxyHosts).equals(originalNonProxyHosts)) {
            return nonProxyHosts;
        }
        return originalNonProxyHosts;
    }

    private static String compactNonProxyHosts(String hosts) {
        StringTokenizer st = new StringTokenizer(hosts, ",");
        StringBuilder nonProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String h = st.nextToken().trim();
            if (h.length() == 0) continue;
            if (nonProxyHosts.length() > 0) {
                nonProxyHosts.append("|");
            }
            nonProxyHosts.append(h);
        }
        st = new StringTokenizer(nonProxyHosts.toString(), "|");
        HashSet<String> set = new HashSet<String>();
        StringBuilder compactedProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!set.add(t.toLowerCase(Locale.ENGLISH))) continue;
            if (compactedProxyHosts.length() > 0) {
                compactedProxyHosts.append('|');
            }
            compactedProxyHosts.append(t);
        }
        return compactedProxyHosts.toString();
    }
}

