/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBoxSupport;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.openide.awt.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AnnotationsPanel
extends JPanel
implements ActionListener,
ItemListener,
FontsColorsController {
    private ColorModel colorModel;
    private String currentProfile;
    private Map<String, List<AttributeSet>> profiles;
    private Set<String> toBeSaved;
    private boolean changed;
    private boolean listen;
    private JComboBox cbBackground;
    private JComboBox cbEffectColor;
    private JComboBox cbEffects;
    private JComboBox cbForeground;
    private JScrollPane cpCategories;
    private JList<AttributeSet> lCategories;
    private JLabel lCategory;
    private JLabel lEffectColor;
    private JLabel lEffects;
    private JLabel lForeground;
    private JLabel lbackground;

    public AnnotationsPanel() {
        this.initComponents();
        this.setName(AnnotationsPanel.loc("Annotations_tab"));
        this.cbForeground.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Foreground_Chooser"));
        this.cbForeground.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Foreground_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Background_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Background_Chooser"));
        this.cbEffectColor.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Wave_Underlined"));
        this.cbEffectColor.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Wave_Underlined"));
        this.lCategories.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Categories"));
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(evt -> {
            if (this.listen) {
                this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbForeground.addItemListener(this);
        this.cbBackground.addItemListener(this);
        this.cbEffectColor.addItemListener(this);
        this.lCategory.setLabelFor(this.lCategories);
        AnnotationsPanel.loc(this.lCategory, "CTL_Category");
        AnnotationsPanel.loc(this.lForeground, "CTL_Foreground_label");
        AnnotationsPanel.loc(this.lEffectColor, "CTL_Effects_color");
        AnnotationsPanel.loc(this.lbackground, "CTL_Background_label");
        this.cbEffects.addItem(AnnotationsPanel.loc("CTL_Effects_None"));
        this.cbEffects.addItem(AnnotationsPanel.loc("CTL_Effects_Wave_Underlined"));
        this.cbEffects.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Effects"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Effects"));
        this.cbEffects.addActionListener(this);
        this.clearState();
    }

    private void initComponents() {
        this.lCategory = new JLabel();
        this.cpCategories = new JScrollPane();
        this.lCategories = new JList();
        this.lForeground = new JLabel();
        this.lbackground = new JLabel();
        this.lEffectColor = new JLabel();
        this.cbForeground = new ColorComboBox();
        this.cbBackground = new ColorComboBox();
        this.cbEffectColor = new ColorComboBox();
        this.lEffects = new JLabel();
        this.cbEffects = new JComboBox();
        this.lCategory.setText(NbBundle.getMessage(AnnotationsPanel.class, (String)"CTL_Category"));
        this.cpCategories.setViewportView(this.lCategories);
        this.lForeground.setText(NbBundle.getMessage(AnnotationsPanel.class, (String)"CTL_Foreground_label"));
        this.lbackground.setText(NbBundle.getMessage(AnnotationsPanel.class, (String)"CTL_Background_label"));
        this.lEffectColor.setText(NbBundle.getMessage(AnnotationsPanel.class, (String)"CTL_Effects_color"));
        this.lEffects.setLabelFor(this.cbEffects);
        this.lEffects.setText(NbBundle.getMessage(AnnotationsPanel.class, (String)"CTL_Effects_label"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cpCategories, -1, 168, Short.MAX_VALUE).addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbackground).addComponent(this.lForeground).addComponent(this.lEffects).addComponent(this.lEffectColor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbEffectColor, 0, -1, Short.MAX_VALUE).addComponent(this.cbForeground, GroupLayout.Alignment.TRAILING, 0, 138, Short.MAX_VALUE).addComponent(this.cbBackground, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.cbEffects, 0, -1, Short.MAX_VALUE))).addComponent(this.lCategory)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lCategory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lForeground).addComponent(this.cbForeground, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbackground).addComponent(this.cbBackground, -2, -1, -2)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lEffects).addComponent(this.cbEffects, -2, -1, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lEffectColor).addComponent(this.cbEffectColor, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.cpCategories, -1, 258, Short.MAX_VALUE)).addContainerGap()));
        this.lEffects.getAccessibleContext().setAccessibleName("&Effect:");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getSource() == this.cbEffects) {
            if (this.cbEffects.getSelectedIndex() == 0) {
                this.cbEffectColor.setSelectedItem(null);
            } else if (this.cbEffectColor.getSelectedItem() == null) {
                this.cbEffectColor.setSelectedIndex(0);
            }
            this.cbEffectColor.setEnabled(this.cbEffects.getSelectedIndex() > 0);
            this.updateData();
        }
        this.updateData();
        this.fireChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.fireChanged();
    }

    private void clearState() {
        this.toBeSaved = new HashSet<String>();
        this.profiles = new HashMap<String, List<AttributeSet>>();
        this.changed = false;
        this.currentProfile = null;
    }

    @Override
    public void update(ColorModel colorModel) {
        this.clearState();
        this.colorModel = colorModel;
        this.setCurrentProfile(colorModel.getCurrentProfile());
        this.toBeSaved.remove(this.currentProfile);
        this.changed = false;
    }

    @Override
    public void cancel() {
        this.clearState();
    }

    @Override
    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        boolean currentChanged = this.toBeSaved.remove(this.currentProfile);
        for (String scheme : this.toBeSaved) {
            this.colorModel.setAnnotations(scheme, this.getAnnotations(scheme));
        }
        if (currentChanged) {
            this.colorModel.setAnnotations(this.currentProfile, this.getAnnotations(this.currentProfile));
        }
        this.clearState();
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setCurrentProfile(String profile) {
        if (profile.equals(this.currentProfile)) {
            return;
        }
        if (!this.profiles.containsKey(profile) && !this.colorModel.getProfiles().contains(profile)) {
            this.profiles.put(profile, AnnotationsPanel.copy(this.getAnnotations(this.currentProfile)));
        }
        this.toBeSaved.add(profile);
        this.currentProfile = profile;
        this.invokeWithoutListeners(() -> {
            int selected = Math.max(this.lCategories.getSelectedIndex(), 0);
            this.lCategories.setListData((AttributeSet[])((AttributeSet[])this.getAnnotations(profile).toArray(AttributeSet[]::new)));
            if (this.lCategories.getModel().getSize() > selected) {
                this.lCategories.setSelectedIndex(selected);
            }
        });
        this.refreshUI();
        this.fireChanged();
    }

    @Override
    public void deleteProfile(String profile) {
        if (this.colorModel.isCustomProfile(profile)) {
            this.profiles.put(profile, null);
        } else {
            this.profiles.put(profile, AnnotationsPanel.copy(this.getDefaults(profile)));
            this.invokeWithoutListeners(() -> {
                int selected = Math.max(this.lCategories.getSelectedIndex(), 0);
                this.lCategories.setListData((AttributeSet[])((AttributeSet[])this.getAnnotations(profile).toArray(AttributeSet[]::new)));
                if (this.lCategories.getModel().getSize() > selected) {
                    this.lCategories.setSelectedIndex(selected);
                }
            });
            this.refreshUI();
        }
        this.toBeSaved.add(profile);
        this.fireChanged();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private static String loc(String key) {
        return NbBundle.getMessage(SyntaxColoringPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)c;
            Mnemonics.setLocalizedText((AbstractButton)button, (String)AnnotationsPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)AnnotationsPanel.loc(key));
        }
    }

    private void invokeWithoutListeners(Runnable run) {
        try {
            this.listen = false;
            run.run();
        }
        finally {
            this.listen = true;
        }
    }

    private void updateData() {
        List<AttributeSet> annotations = this.getAnnotations(this.currentProfile);
        int index = this.lCategories.getSelectedIndex();
        SimpleAttributeSet c = new SimpleAttributeSet(annotations.get(index));
        Color color = ColorComboBoxSupport.getSelectedColor((ColorComboBox)this.cbBackground);
        if (color != null) {
            c.addAttribute(StyleConstants.Background, color);
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        color = ColorComboBoxSupport.getSelectedColor((ColorComboBox)this.cbForeground);
        if (color != null) {
            c.addAttribute(StyleConstants.Foreground, color);
        } else {
            c.removeAttribute(StyleConstants.Foreground);
        }
        Color wave = null;
        if (this.cbEffects.getSelectedIndex() == 1) {
            wave = ColorComboBoxSupport.getSelectedColor((ColorComboBox)this.cbEffectColor);
        }
        if (wave != null) {
            c.addAttribute(EditorStyleConstants.WaveUnderlineColor, wave);
        } else {
            c.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        annotations.set(index, c);
        this.toBeSaved.add(this.currentProfile);
    }

    private void fireChanged() {
        boolean isChanged = false;
        for (String profile : this.toBeSaved) {
            List<AttributeSet> attributeSet = this.getAnnotations(profile);
            Map<String, AttributeSet> savedAnnotations = this.toMap(this.colorModel.getAnnotations(profile));
            Map<String, AttributeSet> currentAnnotations = this.toMap(attributeSet);
            if (savedAnnotations != null && currentAnnotations != null) {
                isChanged = savedAnnotations.size() >= currentAnnotations.size() ? (isChanged |= this.checkMaps(savedAnnotations, currentAnnotations)) : (isChanged |= this.checkMaps(currentAnnotations, savedAnnotations));
            } else if (savedAnnotations != null && currentAnnotations == null) {
                isChanged = true;
            }
            if (!isChanged) continue;
            this.changed = true;
            return;
        }
        this.changed = isChanged;
    }

    private boolean checkMaps(Map<String, AttributeSet> savedMap, Map<String, AttributeSet> currentMap) {
        boolean isChanged = false;
        for (String name : savedMap.keySet()) {
            if (!currentMap.containsKey(name)) continue;
            AttributeSet currentAS = currentMap.get(name);
            AttributeSet savedAS = savedMap.get(name);
            Color currentForeground = (Color)currentAS.getAttribute(StyleConstants.Foreground);
            Color savedForeground = (Color)savedAS.getAttribute(StyleConstants.Foreground);
            Color currentBackground = (Color)currentAS.getAttribute(StyleConstants.Background);
            Color savedBackground = (Color)savedAS.getAttribute(StyleConstants.Background);
            Color currentWave = (Color)currentAS.getAttribute(EditorStyleConstants.WaveUnderlineColor);
            Color savedWave = (Color)savedAS.getAttribute(EditorStyleConstants.WaveUnderlineColor);
            if (!(isChanged |= (currentForeground != null ? !currentForeground.equals(savedForeground) : savedForeground != null) || (currentBackground != null ? !currentBackground.equals(savedBackground) : savedBackground != null) || (currentWave == null ? savedWave != null : !currentWave.equals(savedWave)))) continue;
            return true;
        }
        return isChanged;
    }

    private Map<String, AttributeSet> toMap(Collection<AttributeSet> categories) {
        if (categories == null) {
            return null;
        }
        HashMap<String, AttributeSet> result = new HashMap<String, AttributeSet>();
        for (AttributeSet as : categories) {
            result.put((String)as.getAttribute(StyleConstants.NameAttribute), as);
        }
        return result;
    }

    private void refreshUI() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            this.cbForeground.setEnabled(false);
            this.cbBackground.setEnabled(false);
            this.cbEffectColor.setEnabled(false);
            return;
        }
        this.cbForeground.setEnabled(true);
        this.cbBackground.setEnabled(true);
        this.cbEffectColor.setEnabled(true);
        this.invokeWithoutListeners(() -> {
            AttributeSet defAs = this.getDefaultColoring(this.currentProfile);
            if (defAs != null) {
                Color inheritedForeground = (Color)defAs.getAttribute(StyleConstants.Foreground);
                if (inheritedForeground == null) {
                    inheritedForeground = Color.black;
                }
                ColorComboBoxSupport.setInheritedColor((ColorComboBox)this.cbForeground, inheritedForeground);
                Color inheritedBackground = (Color)defAs.getAttribute(StyleConstants.Background);
                if (inheritedBackground == null) {
                    inheritedBackground = Color.white;
                }
                ColorComboBoxSupport.setInheritedColor((ColorComboBox)this.cbBackground, inheritedBackground);
            }
            AttributeSet c = this.getAnnotations(this.currentProfile).get(index);
            ColorComboBoxSupport.setSelectedColor((ColorComboBox)this.cbForeground, (Color)c.getAttribute(StyleConstants.Foreground));
            ColorComboBoxSupport.setSelectedColor((ColorComboBox)this.cbBackground, (Color)c.getAttribute(StyleConstants.Background));
            if (c.getAttribute(EditorStyleConstants.WaveUnderlineColor) != null) {
                this.cbEffects.setSelectedIndex(1);
                this.cbEffectColor.setEnabled(true);
                ((ColorComboBox)this.cbEffectColor).setSelectedColor((Color)c.getAttribute(EditorStyleConstants.WaveUnderlineColor));
            } else {
                this.cbEffects.setSelectedIndex(0);
                this.cbEffectColor.setEnabled(false);
                this.cbEffectColor.setSelectedIndex(-1);
            }
        });
    }

    private AttributeSet getDefaultColoring(String profile) {
        for (AttributeSet set : this.colorModel.getCategories(profile, ColorModel.ALL_LANGUAGES)) {
            if (!"default".equals(set.getAttribute(StyleConstants.NameAttribute))) continue;
            return set.copyAttributes();
        }
        return null;
    }

    private List<AttributeSet> getAnnotations(String profile) {
        if (!this.profiles.containsKey(profile)) {
            List<AttributeSet> copy = AnnotationsPanel.copy(this.colorModel.getAnnotations(profile));
            copy.sort(new CategoryComparator());
            this.profiles.put(profile, copy);
        }
        return this.profiles.get(profile);
    }

    private List<AttributeSet> getDefaults(String profile) {
        ArrayList<AttributeSet> defaults = new ArrayList<AttributeSet>(this.colorModel.getAnnotationsDefaults(profile));
        defaults.sort(new CategoryComparator());
        return defaults;
    }

    private static List<AttributeSet> copy(Collection<AttributeSet> annotations) {
        ArrayList<AttributeSet> copy = new ArrayList<AttributeSet>(annotations.size());
        for (AttributeSet set : annotations) {
            copy.add(set.copyAttributes());
        }
        return copy;
    }
}

