/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.impl.Bundle;
import org.netbeans.modules.profiler.ui.NBHTMLLabel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

final class ProfilerDialogs {
    private static final Logger LOGGER = Logger.getLogger(ProfilerDialogs.class.getName());
    private static boolean DEBUG = System.getProperty("org.netbeans.modules.profiler.ui.ProfilerDialogs") != null;
    private static final DialogDisplayer standard = DialogDisplayer.getDefault();
    private static boolean silent = false;

    private ProfilerDialogs() {
    }

    public static void setSilent(boolean value) {
        silent = value;
    }

    public static Dialog createDialog(DialogDescriptor descriptor) {
        descriptor.setLeaf(true);
        return standard.createDialog(descriptor);
    }

    public static Object notify(NotifyDescriptor descriptor) {
        if (silent) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Silently closed message: " + descriptor.getMessage());
            }
            return NotifyDescriptor.CLOSED_OPTION;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("notify: " + descriptor.getClass().getName());
        }
        if (descriptor instanceof DNSAMessage) {
            DNSAMessage dm = (DNSAMessage)descriptor;
            Object autoAccept = ProfilerDialogs.stringToNDOption(ProfilerIDESettings.getInstance().getDoNotShowAgain(dm.getDNSAKey()));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DNSAMessage key: " + dm.getDNSAKey() + ", autoAccept: " + autoAccept);
            }
            if (autoAccept != null) {
                return autoAccept;
            }
            DNSAPanel dp = new DNSAPanel(dm.getMessage(), dm.getDNSADefault(), dm.getDNSAMessage());
            dm.setMessage(dp);
            Object ret = standard.notify(descriptor);
            if (ret != DialogDescriptor.CANCEL_OPTION && ret != DialogDescriptor.CLOSED_OPTION && dp.isAutoChecked()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("DNSAMessage key: " + dm.getDNSAKey() + ", setting autoAccept: " + autoAccept);
                }
                ProfilerIDESettings.getInstance().setDoNotShowAgain(dm.getDNSAKey(), ProfilerDialogs.ndOptionToString(ret));
            }
            return ret;
        }
        if (descriptor instanceof DNSAConfirmation) {
            DNSAConfirmation dm = (DNSAConfirmation)descriptor;
            Object autoAccept = ProfilerDialogs.stringToNDOption(ProfilerIDESettings.getInstance().getDoNotShowAgain(dm.getDNSAKey()));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DNSAConfirmation key: " + dm.getDNSAKey() + ", autoAccept: " + autoAccept);
            }
            if (autoAccept != null) {
                return autoAccept;
            }
            DNSAPanel dp = new DNSAPanel(dm.getMessage(), dm.getDNSADefault(), dm.getDNSAMessage());
            dm.setMessage(dp);
            Object ret = standard.notify(descriptor);
            if (ret != DialogDescriptor.CANCEL_OPTION && ret != DialogDescriptor.CLOSED_OPTION && dp.isAutoChecked()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("ProfilerDialogs: DNSAConfirmation key: " + dm.getDNSAKey() + ", setting autoAccept: " + autoAccept);
                }
                ProfilerIDESettings.getInstance().setDoNotShowAgain(dm.getDNSAKey(), ProfilerDialogs.ndOptionToString(ret));
            }
            return ret;
        }
        if (descriptor instanceof DNSAConfirmationChecked) {
            DNSAConfirmationChecked dm = (DNSAConfirmationChecked)descriptor;
            Object autoAccept = ProfilerDialogs.stringToNDOption(ProfilerIDESettings.getInstance().getDoNotShowAgain(dm.getDNSAKey()));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DNSAConfirmationChecked key: " + dm.getDNSAKey() + ", autoAccept: " + autoAccept);
            }
            if (autoAccept != null) {
                return autoAccept;
            }
            DNSAPanel dp = new DNSAPanel(dm.getMessage(), dm.getDNSADefault(), dm.getDNSAMessage());
            dm.setMessage(dp);
            Object ret = standard.notify(descriptor);
            if (ret != DialogDescriptor.CANCEL_OPTION && ret != DialogDescriptor.CLOSED_OPTION && dp.isAutoChecked() && ret != DialogDescriptor.NO_OPTION) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("ProfilerDialogs: DNSAConfirmationChecked key: " + dm.getDNSAKey() + ", setting autoAccept: " + autoAccept);
                }
                ProfilerIDESettings.getInstance().setDoNotShowAgain(dm.getDNSAKey(), ProfilerDialogs.ndOptionToString(ret));
            }
            return ret;
        }
        if (descriptor instanceof MessageWithDetails) {
            MessageWithDetails dm;
            Object returnObj;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("MessageWithDetails message:" + ((MessageWithDetails)descriptor).getDetailsMessage());
            }
            if ((returnObj = standard.notify((NotifyDescriptor)(dm = (MessageWithDetails)descriptor))) == dm.getShowDetailsButton()) {
                returnObj = standard.notify((NotifyDescriptor)new NotifyDescriptor.Message(dm.getDetailsMessage(), dm.getMessageType()));
            }
            return returnObj;
        }
        return standard.notify(descriptor);
    }

    private static String ndOptionToString(Object option) {
        if (option == NotifyDescriptor.CANCEL_OPTION) {
            return "CANCEL_OPTION";
        }
        if (option == NotifyDescriptor.CLOSED_OPTION) {
            return "CLOSED_OPTION";
        }
        if (option == NotifyDescriptor.NO_OPTION) {
            return "NO_OPTION";
        }
        if (option == NotifyDescriptor.OK_OPTION) {
            return "OK_OPTION";
        }
        if (option == NotifyDescriptor.YES_OPTION) {
            return "YES_OPTION";
        }
        return null;
    }

    private static Object stringToNDOption(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("CANCEL_OPTION")) {
            return NotifyDescriptor.CANCEL_OPTION;
        }
        if (string.equals("CLOSED_OPTION")) {
            return NotifyDescriptor.CLOSED_OPTION;
        }
        if (string.equals("NO_OPTION")) {
            return NotifyDescriptor.NO_OPTION;
        }
        if (string.equals("OK_OPTION")) {
            return NotifyDescriptor.OK_OPTION;
        }
        if (string.equals("YES_OPTION")) {
            return NotifyDescriptor.YES_OPTION;
        }
        return null;
    }

    public static final class DNSAMessage
    extends NotifyDescriptor.Message {
        private final String dnsaKey;
        private String dnsaMessage = Bundle.ProfilerDialogs_DontShowAgainMsg();
        private boolean dnsaDefault = true;

        public DNSAMessage(String key, Object message) {
            super(message);
            this.dnsaKey = key;
        }

        public DNSAMessage(String dnsaKey, Object message, int messageType) {
            super(message, messageType);
            this.dnsaKey = dnsaKey;
        }

        public void setDNSADefault(boolean value) {
            this.dnsaDefault = value;
        }

        public boolean getDNSADefault() {
            return this.dnsaDefault;
        }

        public String getDNSAKey() {
            return this.dnsaKey;
        }

        public void setDNSAMessage(String value) {
            this.dnsaMessage = value;
        }

        public String getDNSAMessage() {
            return this.dnsaMessage;
        }
    }

    private static final class DNSAPanel
    extends JPanel {
        private final JCheckBox check;

        DNSAPanel(Object message, boolean defaultSel, String dnsaMessage) {
            Object messageComponent = null;
            if (message instanceof Component) {
                messageComponent = (Component)message;
            } else if (message instanceof String) {
                messageComponent = new NBHTMLLabel((String)message);
                ((Component)messageComponent).setFocusable(false);
            }
            this.setLayout(new BorderLayout(0, 10));
            this.check = new JCheckBox(dnsaMessage, defaultSel);
            if (messageComponent != null) {
                this.add((Component)messageComponent, "Center");
            }
            this.add((Component)this.check, "South");
        }

        public boolean isAutoChecked() {
            return this.check.isSelected();
        }
    }

    public static final class DNSAConfirmation
    extends NotifyDescriptor.Confirmation {
        private final String dnsaKey;
        private String dnsaMessage = Bundle.ProfilerDialogs_DontShowAgainMsg();
        private boolean dnsaDefault = true;

        public DNSAConfirmation(String key, Object message) {
            super(message);
            this.dnsaKey = key;
        }

        public DNSAConfirmation(String key, Object message, String title) {
            super(message, title);
            this.dnsaKey = key;
        }

        public DNSAConfirmation(String key, Object message, int optionType) {
            super(message, optionType);
            this.dnsaKey = key;
        }

        public DNSAConfirmation(String key, Object message, String title, int optionType) {
            super(message, title, optionType);
            this.dnsaKey = key;
        }

        public DNSAConfirmation(String key, Object message, int optionType, int messageType) {
            super(message, optionType, messageType);
            this.dnsaKey = key;
        }

        public DNSAConfirmation(String key, Object message, String title, int optionType, int messageType) {
            super(message, title, optionType, messageType);
            this.dnsaKey = key;
        }

        public void setDNSADefault(boolean value) {
            this.dnsaDefault = value;
        }

        public boolean getDNSADefault() {
            return this.dnsaDefault;
        }

        public String getDNSAKey() {
            return this.dnsaKey;
        }

        public void setDNSAMessage(String value) {
            this.dnsaMessage = value;
        }

        public String getDNSAMessage() {
            return this.dnsaMessage;
        }
    }

    public static final class DNSAConfirmationChecked
    extends NotifyDescriptor.Confirmation {
        private final String dnsaKey;
        private String dnsaMessage = Bundle.ProfilerDialogs_DontShowAgainMsg();
        private boolean dnsaDefault = false;

        public DNSAConfirmationChecked(String key, Object message) {
            super(message);
            this.dnsaKey = key;
        }

        public DNSAConfirmationChecked(String key, Object message, String title) {
            super(message, title);
            this.dnsaKey = key;
        }

        public DNSAConfirmationChecked(String key, Object message, int optionType) {
            super(message, optionType);
            this.dnsaKey = key;
        }

        public DNSAConfirmationChecked(String key, Object message, String title, int optionType) {
            super(message, title, optionType);
            this.dnsaKey = key;
        }

        public DNSAConfirmationChecked(String key, Object message, int optionType, int messageType) {
            super(message, optionType, messageType);
            this.dnsaKey = key;
        }

        public DNSAConfirmationChecked(String key, Object message, String title, int optionType, int messageType) {
            super(message, title, optionType, messageType);
            this.dnsaKey = key;
        }

        public void setDNSADefault(boolean value) {
            this.dnsaDefault = value;
        }

        public boolean getDNSADefault() {
            return this.dnsaDefault;
        }

        public String getDNSAKey() {
            return this.dnsaKey;
        }

        public void setDNSAMessage(String value) {
            this.dnsaMessage = value;
        }

        public String getDNSAMessage() {
            return this.dnsaMessage;
        }
    }

    public static final class MessageWithDetails
    extends DialogDescriptor {
        private JButton showDetailsButton = new JButton(Bundle.ProfilerDialogs_ShowDetailsButtonText());
        private Object detailsMsg;

        public MessageWithDetails(Object shortMsg, Object detailsMsg, boolean respectParent) {
            super(shortMsg, NotifyDescriptor.getTitleForType((int)1));
            this.detailsMsg = detailsMsg;
            this.showDetailsButton.setDefaultCapable(false);
            this.setOptions(new Object[]{OK_OPTION});
            this.setAdditionalOptions(new Object[]{this.showDetailsButton});
            this.setLeaf(!respectParent);
        }

        public MessageWithDetails(Object shortMsg, Object detailsMsg, int messageType, boolean respectParent) {
            super(shortMsg, NotifyDescriptor.getTitleForType((int)messageType));
            this.setMessageType(messageType);
            this.detailsMsg = detailsMsg;
            this.showDetailsButton.setDefaultCapable(false);
            this.setOptions(new Object[]{OK_OPTION});
            this.setAdditionalOptions(new Object[]{this.showDetailsButton});
            this.setLeaf(!respectParent);
        }

        public Object getDetailsMessage() {
            return this.detailsMsg;
        }

        public Object getShortMessage() {
            return this.getMessage();
        }

        public JButton getShowDetailsButton() {
            return this.showDetailsButton;
        }
    }
}

