/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.refactoring.api.CssRefactoringExtraInfo;
import org.netbeans.modules.css.refactoring.api.CssRefactoringInfo;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.html.editor.indexing.Entry;
import org.netbeans.modules.html.editor.indexing.HtmlFileModel;
import org.netbeans.modules.html.editor.refactoring.DiffElement;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CssRenameRefactoringPlugin
implements RefactoringPlugin {
    private static final String SELECTOR_RENAME_MSG_KEY = "MSG_Rename_Selector";
    private static final String UNRELATED_PREFIX_MSG_KEY = "MSG_Unrelated_Prefix";
    private static final Logger LOGGER = Logger.getLogger(CssRenameRefactoringPlugin.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final RenameRefactoring refactoring;
    private final Lookup lookup;
    private final CssRefactoringInfo context;

    public CssRenameRefactoringPlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
        this.lookup = refactoring.getRefactoringSource();
        this.context = (CssRefactoringInfo)this.lookup.lookup(CssRefactoringInfo.class);
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        String newName = this.refactoring.getNewName();
        if (newName.length() == 0) {
            return new Problem(true, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Error_ElementEmpty"));
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return this.checkParameters();
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        CssIndex index;
        Project project = FileOwnerQuery.getOwner((FileObject)this.context.getFileObject());
        if (project == null) {
            return null;
        }
        try {
            index = CssIndex.get((Project)project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ModificationResult modificationResult = new ModificationResult();
        if (this.context != null) {
            CssRefactoringInfo.Type kind = this.context.getType();
            String elementImage = this.context.getElementName();
            switch (kind) {
                case CLASS: {
                    Collection files = index.findClasses(elementImage);
                    this.refactor(this.lookup, modificationResult, RefactoringElementType.CLASS, files, this.context, index, SELECTOR_RENAME_MSG_KEY);
                    break;
                }
                case ID: {
                    Collection files = index.findIds(elementImage);
                    this.refactor(this.lookup, modificationResult, RefactoringElementType.ID, files, this.context, index, SELECTOR_RENAME_MSG_KEY);
                }
            }
        }
        refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
            }
        }
        return null;
    }

    private void refactor(Lookup lookup, ModificationResult modificationResult, RefactoringElementType type, Collection<FileObject> files, CssRefactoringInfo context, CssIndex index, String renameMsgKey) {
        String elementImage = context.getElementName();
        LinkedList<FileObject> involvedFiles = new LinkedList<FileObject>(files);
        DependenciesGraph deps = index.getDependencies(context.getFileObject());
        Collection relatedFiles = deps.getAllRelatedFiles();
        CssRefactoringExtraInfo extraInfo = (CssRefactoringExtraInfo)lookup.lookup(CssRefactoringExtraInfo.class);
        if (extraInfo == null || !extraInfo.isRefactorAll()) {
            involvedFiles.retainAll(relatedFiles);
        }
        if (LOG) {
            LOGGER.log(Level.FINE, "Refactoring element {0} in file {1}", new Object[]{elementImage, context.getFileObject().getPath()});
            LOGGER.log(Level.FINE, "Involved files declaring the element {0}:", elementImage);
            for (FileObject fo : involvedFiles) {
                LOGGER.log(Level.FINE, "{0}\n", fo.getPath());
            }
        }
        String newName = this.refactoring.getNewName();
        for (FileObject file : involvedFiles) {
            try {
                CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                HtmlFileModel model = new HtmlFileModel(source);
                Collection<Object> entries = RefactoringElementType.ID == type && model.getIds().containsKey(elementImage) ? Arrays.asList(model.getIds().get(elementImage)) : (RefactoringElementType.CLASS == type && model.getCssClasses().containsKey(elementImage) ? (Collection)model.getCssClasses().get(elementImage) : Collections.emptyList());
                boolean related = relatedFiles.contains(file);
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                for (Entry entry : entries) {
                    if (!entry.isValidInSourceDocument()) continue;
                    diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), newName, related ? NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)renameMsgKey) : NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)UNRELATED_PREFIX_MSG_KEY) + " " + NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)renameMsgKey)));
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(file, diffs);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

