/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.PatternRule;
import org.netbeans.modules.html.editor.spi.HintFixProvider;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.util.Lookup;

public class Element
extends PatternRule {
    private static final String[] PATTERNS_SOURCES = new String[]{"Attribute (.*?) not allowed on element (.*?) at this point", "Required attributes missing on element", "The ./>. syntax on void elements is not allowed.  (This is an HTML4-only error.)", "No space between attributes", "Saw .<\\. when expecting an attribute name. Probable cause: Missing .>. immediately before.", "Bad character ... after .<.. Probable cause: Unescaped .<\\.. Try escaping it as .&lt;..", "Saw .<>.. Probable causes: Unescaped .<\\. (escape as .&lt;.) or mistyped start tag.", "End tag had attributes.", "Stray ./. at the end of an end tag.", "Saw end of file without the previous tag ending", "End of file seen when looking for tag name. Ignoring tag.", "End of file inside end tag. Ignoring tag.", "End of file after .<\\.", "Duplicate attribute", "Self-closing syntax (./>.) used on a non-void HTML element", "Text not allowed in element .*? in this context", "XHTML element .*? not allowed as child of XHTML element .*? in this context.", "Attribute .*? not allowed on XHTML element .*? at this point.", "The end-tag for element type .*? must end with a '>' delimiter."};
    private static final Pattern[] PATTERNS = Element.buildPatterns(PATTERNS_SOURCES);
    private static final int UNKNOWN_ATTRIBUTE_PATTERN_INDEX = 0;

    @Override
    public Pattern[] getPatterns() {
        return PATTERNS;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    @Override
    protected List<HintFix> getExtraHintFixes(Error e, HtmlRuleContext context) {
        if (this.matched_pattern_index == 0) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.addAll(super.getExtraHintFixes(e, context));
            fixes.addAll(this.getSPIHintFixes(e, context));
            return fixes;
        }
        return super.getExtraHintFixes(e, context);
    }

    private List<HintFix> getSPIHintFixes(Error e, HtmlRuleContext context) {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        Pattern p = PATTERNS[0];
        Matcher matcher = p.matcher(e.getDescription());
        if (matcher.matches()) {
            String unknownElement = WebUtils.unquotedValue((CharSequence)matcher.group(1).trim());
            String contextElement = WebUtils.unquotedValue((CharSequence)matcher.group(2).trim());
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("unknown_attribute_found", unknownElement);
            meta.put("unknown_element_context", contextElement);
            HintFixProvider.Context ctx = new HintFixProvider.Context(context.getSnapshot(), context.getHtmlParserResult(), meta);
            for (HintFixProvider provider : Lookup.getDefault().lookupAll(HintFixProvider.class)) {
                fixes.addAll(provider.getHintFixes(ctx));
            }
        }
        return fixes;
    }
}

