/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.embedding;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.embedding.CssHtmlTranslator;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;

public class CssEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOG = Logger.getLogger(CssEmbeddingProvider.class.getSimpleName());
    private static final long MAX_SNAPSHOT_SIZE = 0x400000L;
    private static final String HTML_MIME_TYPE = "text/html";
    private String sourceMimeType = "text/html";
    private Translator translator = new CssHtmlTranslator();

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if (this.sourceMimeType.equals(snapshot.getMimeType())) {
            int slen = snapshot.getText().length();
            LOG.fine(String.format("CssEmbeddingProvider.create(snapshot): mimetype: %s, size: %s", snapshot.getMimeType(), slen));
            if ((long)slen > 0x400000L) {
                LOG.fine(String.format("Size %s > maximum (%s) => providing no css embedding", slen, 0x400000L));
                return Collections.emptyList();
            }
            List<Embedding> embeddings = this.translator.getEmbeddings(snapshot);
            if (embeddings.isEmpty()) {
                return Collections.singletonList(snapshot.create((CharSequence)"", "text/css"));
            }
            return Collections.singletonList(Embedding.create(embeddings));
        }
        LOG.log(Level.WARNING, "Unexpected snapshot type: ''{0}''; expecting ''{1}''", new Object[]{snapshot.getMimeType(), this.sourceMimeType});
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    public static interface Translator {
        public List<Embedding> getEmbeddings(Snapshot var1);
    }
}

