/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import java.io.IOException;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class NamespaceDroppingXMLReaderWrapper
implements XMLReader,
ContentHandler {
    private static final String[] ARRAY_TYPE = new String[0];
    private final XMLReader wrappedReader;
    private final String[] namespacesToRemove;
    private ContentHandler contentHandler;
    private int depth;
    private boolean alreadyWarnedAboutForeign;
    private boolean alreadyWarnedAboutFiltering;
    private boolean rootSeen;
    private Locator locator = null;

    private static String[] toInternedArray(Set<String> set) {
        String[] rv = set.toArray(ARRAY_TYPE);
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = rv[i].intern();
        }
        return rv;
    }

    public NamespaceDroppingXMLReaderWrapper(XMLReader wrappedReader, Set<String> namespacesToRemove) {
        this.wrappedReader = wrappedReader;
        this.namespacesToRemove = NamespaceDroppingXMLReaderWrapper.toInternedArray(namespacesToRemove);
        this.contentHandler = wrappedReader.getContentHandler();
        wrappedReader.setContentHandler(this);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.depth == 0) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.depth == 0) {
            this.contentHandler.endElement(uri, localName, qName);
        } else {
            --this.depth;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.depth = 0;
        this.alreadyWarnedAboutForeign = false;
        this.alreadyWarnedAboutFiltering = false;
        this.rootSeen = false;
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.depth == 0) {
            if (this.isInNamespacesToRemove(uri)) {
                if (this.rootSeen) {
                    this.depth = 1;
                    if (!this.alreadyWarnedAboutFiltering) {
                        this.warning(new SAXParseException("Content is being hidden from the validator based on namespace filtering.", this.locator));
                        this.alreadyWarnedAboutFiltering = true;
                    }
                } else {
                    this.warning(new SAXParseException("Cannot filter out the root element.", this.locator));
                    this.contentHandler.startElement(uri, localName, qName, this.filterAttributes(atts));
                }
            } else {
                this.contentHandler.startElement(uri, localName, qName, this.filterAttributes(atts));
            }
        } else {
            if (!this.alreadyWarnedAboutForeign && !this.isInNamespacesToRemove(uri)) {
                this.warning(new SAXParseException("Filtering out selected namespaces causes descendants in other namespaces to be dropped as well.", this.locator));
                this.alreadyWarnedAboutForeign = true;
            }
            ++this.depth;
        }
        this.rootSeen = true;
    }

    private void warning(SAXParseException exception) throws SAXException {
        this.wrappedReader.getErrorHandler().warning(exception);
    }

    private Attributes filterAttributes(Attributes atts) throws SAXException {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            if (!this.isInNamespacesToRemove(atts.getURI(i))) continue;
            if (!this.alreadyWarnedAboutFiltering) {
                this.warning(new SAXParseException("Content is being hidden from the validator based on namespace filtering.", this.locator));
                this.alreadyWarnedAboutFiltering = true;
            }
            AttributesImpl rv = new AttributesImpl();
            for (int j = 0; j < i; ++j) {
                rv.addAttribute(atts.getURI(j), atts.getLocalName(j), atts.getQName(j), atts.getType(j), atts.getValue(j));
            }
            ++i;
            while (i < length) {
                String uri = atts.getURI(i);
                if (!this.isInNamespacesToRemove(uri)) {
                    rv.addAttribute(uri, atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
                }
                ++i;
            }
            return rv;
        }
        return atts;
    }

    private boolean isInNamespacesToRemove(String uri) {
        for (String namespace : this.namespacesToRemove) {
            if (uri != namespace) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.wrappedReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.wrappedReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.wrappedReader.getErrorHandler();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getProperty(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.wrappedReader.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.wrappedReader.parse(systemId);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.wrappedReader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.wrappedReader.setEntityResolver(resolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.wrappedReader.setErrorHandler(handler);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setFeature(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setProperty(name, value);
    }
}

