/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public class IriRef
extends AbstractDatatype {
    private static final int ELIDE_LIMIT = 50;
    public static final IriRef THE_INSTANCE = new IriRef();
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");

    protected IriRef() {
    }

    private final CharSequencePair splitScheme(CharSequence iri) {
        StringBuilder sb = new StringBuilder();
        Boolean atSchemeBeginning = true;
        for (int i = 0; i < iri.length(); ++i) {
            char c = IriRef.toAsciiLowerCase(iri.charAt(i));
            if (atSchemeBeginning.booleanValue()) {
                if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
                if ('a' <= c && 'z' >= c) {
                    atSchemeBeginning = false;
                    sb.append(c);
                    continue;
                }
                return null;
            }
            if ('a' <= c && 'z' >= c || '0' <= c && '9' >= c || c == '+' || c == '.') {
                sb.append(c);
                continue;
            }
            if (c == ':') {
                return new CharSequencePair(sb, iri.subSequence(i + 1, iri.length()));
            }
            return null;
        }
        return null;
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
    }

    private final boolean isHttpOrHttps(CharSequence scheme) {
        return "http".contentEquals(scheme) || "https".contentEquals(scheme);
    }

    private final boolean isHttpAlias(CharSequence scheme) {
        return "feed".contentEquals(scheme) || "webcal".contentEquals(scheme);
    }

    private final boolean isWellKnown(CharSequence scheme) {
        return "http".contentEquals(scheme) || "https".contentEquals(scheme) || "ftp".contentEquals(scheme) || "mailto".contentEquals(scheme) || "file".contentEquals(scheme);
    }

    protected boolean isAbsolute() {
        return false;
    }

    protected boolean reportValue() {
        return false;
    }

    protected static final String trimHtmlSpaces(String str) {
        return IriRef.trimHtmlLeadingSpaces(IriRef.trimHtmlTrailingSpaces(str));
    }

    protected static final String trimHtmlLeadingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length(); i > 0; --i) {
            char c = str.charAt(str.length() - i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(str.length() - i, str.length());
        }
        return "";
    }

    protected static final String trimHtmlTrailingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(0, i + 1);
        }
        return "";
    }

    protected boolean mustBeHttpOrHttps() {
        return false;
    }

    @Override
    public String getName() {
        return "URL";
    }

    private class CharSequencePair {
        private final CharSequence head;
        private final CharSequence tail;

        public CharSequencePair(CharSequence head, CharSequence tail) {
            this.head = head;
            this.tail = tail;
        }

        public CharSequence getHead() {
            return this.head;
        }

        public CharSequence getTail() {
            return this.tail;
        }
    }
}

