/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateInstanceRequest
extends BmcRequest<UpdateInstanceDetails> {
    private String instanceId;
    private UpdateInstanceDetails updateInstanceDetails;
    private String opcRetryToken;
    private String ifMatch;

    public String getInstanceId() {
        return this.instanceId;
    }

    public UpdateInstanceDetails getUpdateInstanceDetails() {
        return this.updateInstanceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateInstanceDetails getBody$() {
        return this.updateInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().instanceId(this.instanceId).updateInstanceDetails(this.updateInstanceDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",updateInstanceDetails=").append(String.valueOf((Object)this.updateInstanceDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateInstanceRequest)) {
            return false;
        }
        UpdateInstanceRequest other = (UpdateInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals((Object)this.updateInstanceDetails, (Object)other.updateInstanceDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.updateInstanceDetails == null ? 43 : this.updateInstanceDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateInstanceRequest, UpdateInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceId = null;
        private UpdateInstanceDetails updateInstanceDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder updateInstanceDetails(UpdateInstanceDetails updateInstanceDetails) {
            this.updateInstanceDetails = updateInstanceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateInstanceRequest o) {
            this.instanceId(o.getInstanceId());
            this.updateInstanceDetails(o.getUpdateInstanceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateInstanceRequest build() {
            UpdateInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateInstanceDetails body) {
            this.updateInstanceDetails(body);
            return this;
        }

        public UpdateInstanceRequest buildWithoutInvocationCallback() {
            UpdateInstanceRequest request = new UpdateInstanceRequest();
            request.instanceId = this.instanceId;
            request.updateInstanceDetails = this.updateInstanceDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

