/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDrgRouteTableRequest
extends BmcRequest<Void> {
    private String drgRouteTableId;

    public String getDrgRouteTableId() {
        return this.drgRouteTableId;
    }

    public Builder toBuilder() {
        return new Builder().drgRouteTableId(this.drgRouteTableId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgRouteTableId=").append(String.valueOf(this.drgRouteTableId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDrgRouteTableRequest)) {
            return false;
        }
        GetDrgRouteTableRequest other = (GetDrgRouteTableRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgRouteTableId, other.drgRouteTableId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgRouteTableId == null ? 43 : this.drgRouteTableId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDrgRouteTableRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgRouteTableId = null;

        public Builder drgRouteTableId(String drgRouteTableId) {
            this.drgRouteTableId = drgRouteTableId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDrgRouteTableRequest o) {
            this.drgRouteTableId(o.getDrgRouteTableId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDrgRouteTableRequest build() {
            GetDrgRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDrgRouteTableRequest buildWithoutInvocationCallback() {
            GetDrgRouteTableRequest request = new GetDrgRouteTableRequest();
            request.drgRouteTableId = this.drgRouteTableId;
            return request;
        }
    }
}

