/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.DetachInstancePoolInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DetachInstancePoolInstanceRequest
extends BmcRequest<DetachInstancePoolInstanceDetails> {
    private String instancePoolId;
    private DetachInstancePoolInstanceDetails detachInstancePoolInstanceDetails;
    private String opcRetryToken;

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public DetachInstancePoolInstanceDetails getDetachInstancePoolInstanceDetails() {
        return this.detachInstancePoolInstanceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public DetachInstancePoolInstanceDetails getBody$() {
        return this.detachInstancePoolInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().instancePoolId(this.instancePoolId).detachInstancePoolInstanceDetails(this.detachInstancePoolInstanceDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instancePoolId=").append(String.valueOf(this.instancePoolId));
        sb.append(",detachInstancePoolInstanceDetails=").append(String.valueOf((Object)this.detachInstancePoolInstanceDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetachInstancePoolInstanceRequest)) {
            return false;
        }
        DetachInstancePoolInstanceRequest other = (DetachInstancePoolInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instancePoolId, other.instancePoolId) && Objects.equals((Object)this.detachInstancePoolInstanceDetails, (Object)other.detachInstancePoolInstanceDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instancePoolId == null ? 43 : this.instancePoolId.hashCode());
        result = result * 59 + (this.detachInstancePoolInstanceDetails == null ? 43 : this.detachInstancePoolInstanceDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DetachInstancePoolInstanceRequest, DetachInstancePoolInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instancePoolId = null;
        private DetachInstancePoolInstanceDetails detachInstancePoolInstanceDetails = null;
        private String opcRetryToken = null;

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder detachInstancePoolInstanceDetails(DetachInstancePoolInstanceDetails detachInstancePoolInstanceDetails) {
            this.detachInstancePoolInstanceDetails = detachInstancePoolInstanceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachInstancePoolInstanceRequest o) {
            this.instancePoolId(o.getInstancePoolId());
            this.detachInstancePoolInstanceDetails(o.getDetachInstancePoolInstanceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachInstancePoolInstanceRequest build() {
            DetachInstancePoolInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DetachInstancePoolInstanceDetails body) {
            this.detachInstancePoolInstanceDetails(body);
            return this;
        }

        public DetachInstancePoolInstanceRequest buildWithoutInvocationCallback() {
            DetachInstancePoolInstanceRequest request = new DetachInstancePoolInstanceRequest();
            request.instancePoolId = this.instancePoolId;
            request.detachInstancePoolInstanceDetails = this.detachInstancePoolInstanceDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

