/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteBootVolumeKmsKeyRequest
extends BmcRequest<Void> {
    private String bootVolumeId;
    private String ifMatch;

    public String getBootVolumeId() {
        return this.bootVolumeId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().bootVolumeId(this.bootVolumeId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bootVolumeId=").append(String.valueOf(this.bootVolumeId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteBootVolumeKmsKeyRequest)) {
            return false;
        }
        DeleteBootVolumeKmsKeyRequest other = (DeleteBootVolumeKmsKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bootVolumeId, other.bootVolumeId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bootVolumeId == null ? 43 : this.bootVolumeId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteBootVolumeKmsKeyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bootVolumeId = null;
        private String ifMatch = null;

        public Builder bootVolumeId(String bootVolumeId) {
            this.bootVolumeId = bootVolumeId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteBootVolumeKmsKeyRequest o) {
            this.bootVolumeId(o.getBootVolumeId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteBootVolumeKmsKeyRequest build() {
            DeleteBootVolumeKmsKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteBootVolumeKmsKeyRequest buildWithoutInvocationCallback() {
            DeleteBootVolumeKmsKeyRequest request = new DeleteBootVolumeKmsKeyRequest();
            request.bootVolumeId = this.bootVolumeId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

