/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MeasuredBootEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="pcrIndex")
    private final String pcrIndex;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="hashAlgorithm")
    private final String hashAlgorithm;

    @Deprecated
    @ConstructorProperties(value={"pcrIndex", "value", "hashAlgorithm"})
    public MeasuredBootEntry(String pcrIndex, String value, String hashAlgorithm) {
        this.pcrIndex = pcrIndex;
        this.value = value;
        this.hashAlgorithm = hashAlgorithm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPcrIndex() {
        return this.pcrIndex;
    }

    public String getValue() {
        return this.value;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MeasuredBootEntry(");
        sb.append("super=").append(super.toString());
        sb.append("pcrIndex=").append(String.valueOf(this.pcrIndex));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", hashAlgorithm=").append(String.valueOf(this.hashAlgorithm));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MeasuredBootEntry)) {
            return false;
        }
        MeasuredBootEntry other = (MeasuredBootEntry)((Object)o);
        return Objects.equals(this.pcrIndex, other.pcrIndex) && Objects.equals(this.value, other.value) && Objects.equals(this.hashAlgorithm, other.hashAlgorithm) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.pcrIndex == null ? 43 : this.pcrIndex.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.hashAlgorithm == null ? 43 : this.hashAlgorithm.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pcrIndex")
        private String pcrIndex;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="hashAlgorithm")
        private String hashAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pcrIndex(String pcrIndex) {
            this.pcrIndex = pcrIndex;
            this.__explicitlySet__.add("pcrIndex");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            this.__explicitlySet__.add("hashAlgorithm");
            return this;
        }

        public MeasuredBootEntry build() {
            MeasuredBootEntry model = new MeasuredBootEntry(this.pcrIndex, this.value, this.hashAlgorithm);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MeasuredBootEntry model) {
            if (model.wasPropertyExplicitlySet("pcrIndex")) {
                this.pcrIndex(model.getPcrIndex());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("hashAlgorithm")) {
                this.hashAlgorithm(model.getHashAlgorithm());
            }
            return this;
        }
    }
}

