/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlockVolumeReplicaInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="blockVolumeReplicaId")
    private final String blockVolumeReplicaId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;

    @Deprecated
    @ConstructorProperties(value={"displayName", "blockVolumeReplicaId", "availabilityDomain"})
    public BlockVolumeReplicaInfo(String displayName, String blockVolumeReplicaId, String availabilityDomain) {
        this.displayName = displayName;
        this.blockVolumeReplicaId = blockVolumeReplicaId;
        this.availabilityDomain = availabilityDomain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getBlockVolumeReplicaId() {
        return this.blockVolumeReplicaId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockVolumeReplicaInfo(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", blockVolumeReplicaId=").append(String.valueOf(this.blockVolumeReplicaId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockVolumeReplicaInfo)) {
            return false;
        }
        BlockVolumeReplicaInfo other = (BlockVolumeReplicaInfo)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.blockVolumeReplicaId, other.blockVolumeReplicaId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.blockVolumeReplicaId == null ? 43 : this.blockVolumeReplicaId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="blockVolumeReplicaId")
        private String blockVolumeReplicaId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder blockVolumeReplicaId(String blockVolumeReplicaId) {
            this.blockVolumeReplicaId = blockVolumeReplicaId;
            this.__explicitlySet__.add("blockVolumeReplicaId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public BlockVolumeReplicaInfo build() {
            BlockVolumeReplicaInfo model = new BlockVolumeReplicaInfo(this.displayName, this.blockVolumeReplicaId, this.availabilityDomain);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BlockVolumeReplicaInfo model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("blockVolumeReplicaId")) {
                this.blockVolumeReplicaId(model.getBlockVolumeReplicaId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            return this;
        }
    }
}

